/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.client;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.ws.rs.core.Configurable;
import org.apache.http.client.HttpClient;

public class RestClientConfiguration {
    public static final RestClientConfiguration DEFAULTS = new RestClientConfiguration(null, null, false);
    private final Supplier<HttpClient> httpClient;
    private final Customizer customizer;
    private final boolean useTrustStore;

    private RestClientConfiguration(@Nullable Supplier<HttpClient> httpClient, @Nullable Customizer customizer, boolean useTrustStore) {
        this.httpClient = httpClient;
        this.customizer = customizer;
        this.useTrustStore = useTrustStore;
    }

    public RestClientConfiguration withHttpClient(@Nullable Supplier<HttpClient> httpClient) {
        return new RestClientConfiguration(httpClient, this.customizer, this.useTrustStore);
    }

    @Nullable
    public Supplier<HttpClient> getHttpClient() {
        return this.httpClient;
    }

    public RestClientConfiguration withCustomizer(@Nullable Customizer customizer) {
        return new RestClientConfiguration(this.httpClient, customizer, this.useTrustStore);
    }

    @Nullable
    public Customizer getCustomizer() {
        return this.customizer;
    }

    public RestClientConfiguration withUseTrustStore(boolean useTrustStore) {
        return new RestClientConfiguration(this.httpClient, this.customizer, useTrustStore);
    }

    public boolean getUseTrustStore() {
        return this.useTrustStore;
    }

    public static interface Customizer {
        public void apply(Configurable<?> var1);
    }
}

