/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.parsers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.LinkedList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.cyclonedx.CycloneDxSchema;
import org.cyclonedx.exception.ParseException;
import org.cyclonedx.model.Bom;
import org.cyclonedx.parsers.Parser;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlParser
extends CycloneDxSchema
implements Parser {
    private final ObjectMapper mapper = new XmlMapper();

    @Override
    public Bom parse(File file) throws ParseException {
        try {
            String schemaVersion = this.identifySchemaVersion(this.extractAllNamespaceDeclarations(new InputSource(Files.newInputStream(file.toPath(), new OpenOption[0]))));
            return this.injectSchemaVersion((Bom)this.mapper.readValue(file, Bom.class), schemaVersion);
        }
        catch (IOException | XPathExpressionException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public Bom parse(byte[] bomBytes) throws ParseException {
        try {
            String schemaVersion = this.identifySchemaVersion(this.extractAllNamespaceDeclarations(new InputSource(new ByteArrayInputStream(bomBytes))));
            return this.injectSchemaVersion((Bom)this.mapper.readValue(bomBytes, Bom.class), schemaVersion);
        }
        catch (IOException | XPathExpressionException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public Bom parse(InputStream inputStream) throws ParseException {
        try {
            return (Bom)this.mapper.readValue(inputStream, Bom.class);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public Bom parse(Reader reader) throws ParseException {
        try {
            return (Bom)this.mapper.readValue(reader, Bom.class);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    private Bom injectSchemaVersion(Bom bom, String schemaVersion) {
        try {
            Field field = Bom.class.getDeclaredField("specVersion");
            field.setAccessible(true);
            field.set(bom, schemaVersion);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return bom;
    }

    @Override
    public List<ParseException> validate(File file) throws IOException {
        return this.validate(file, CycloneDxSchema.VERSION_LATEST);
    }

    @Override
    public List<ParseException> validate(File file, CycloneDxSchema.Version schemaVersion) throws IOException {
        StreamSource source = new StreamSource(file);
        return this.validate(source, schemaVersion);
    }

    @Override
    public List<ParseException> validate(byte[] bomBytes) throws IOException {
        return this.validate(bomBytes, CycloneDxSchema.VERSION_LATEST);
    }

    @Override
    public List<ParseException> validate(byte[] bomBytes, CycloneDxSchema.Version schemaVersion) throws IOException {
        StreamSource source = new StreamSource(new ByteArrayInputStream(bomBytes));
        return this.validate(source, schemaVersion);
    }

    @Override
    public List<ParseException> validate(Reader reader) throws IOException {
        return this.validate(reader, CycloneDxSchema.VERSION_LATEST);
    }

    @Override
    public List<ParseException> validate(Reader reader, CycloneDxSchema.Version schemaVersion) throws IOException {
        StreamSource source = new StreamSource(reader);
        return this.validate(source, schemaVersion);
    }

    @Override
    public List<ParseException> validate(InputStream inputStream) throws IOException {
        return this.validate(inputStream, CycloneDxSchema.VERSION_LATEST);
    }

    @Override
    public List<ParseException> validate(InputStream inputStream, CycloneDxSchema.Version schemaVersion) throws IOException {
        StreamSource source = new StreamSource(inputStream);
        return this.validate(source, schemaVersion);
    }

    public List<ParseException> validate(Source source, CycloneDxSchema.Version schemaVersion) throws IOException {
        final LinkedList<ParseException> exceptions = new LinkedList<ParseException>();
        try {
            Schema schema = this.getXmlSchema(schemaVersion);
            Validator validator = schema.newValidator();
            validator.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException e) {
                    exceptions.add(new ParseException(e.getMessage(), e));
                }

                @Override
                public void fatalError(SAXParseException e) {
                    exceptions.add(new ParseException(e.getMessage(), e));
                }

                @Override
                public void error(SAXParseException e) {
                    exceptions.add(new ParseException(e.getMessage(), e));
                }
            });
            validator.validate(source);
        }
        catch (SAXException e) {
            exceptions.add(new ParseException(e.getMessage(), e));
        }
        return exceptions;
    }

    @Override
    public boolean isValid(File file) throws IOException {
        return this.validate(file).isEmpty();
    }

    @Override
    public boolean isValid(File file, CycloneDxSchema.Version schemaVersion) throws IOException {
        return this.validate(file, schemaVersion).isEmpty();
    }

    @Override
    public boolean isValid(byte[] bomBytes) throws IOException {
        return this.validate(bomBytes).isEmpty();
    }

    @Override
    public boolean isValid(byte[] bomBytes, CycloneDxSchema.Version schemaVersion) throws IOException {
        return this.validate(bomBytes, schemaVersion).isEmpty();
    }

    @Override
    public boolean isValid(Reader reader) throws IOException {
        return this.validate(reader).isEmpty();
    }

    @Override
    public boolean isValid(Reader reader, CycloneDxSchema.Version schemaVersion) throws IOException {
        return this.validate(reader, schemaVersion).isEmpty();
    }

    @Override
    public boolean isValid(InputStream inputStream) throws IOException {
        return this.validate(inputStream).isEmpty();
    }

    @Override
    public boolean isValid(InputStream inputStream, CycloneDxSchema.Version schemaVersion) throws IOException {
        return this.validate(inputStream, schemaVersion).isEmpty();
    }

    private String identifySchemaVersion(NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            for (CycloneDxSchema.Version version : CycloneDxSchema.Version.values()) {
                if (!version.getNamespace().equals(node.getNodeValue())) continue;
                return version.getVersionString();
            }
        }
        return null;
    }

    private NodeList extractAllNamespaceDeclarations(InputSource in) throws XPathExpressionException {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        XPathExpression xPathExpression = xPath.compile("//namespace::*");
        return (NodeList)xPathExpression.evaluate(in, XPathConstants.NODESET);
    }
}

