/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Provider;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;

public class OrientMavenIndexUpgrade
extends DatabaseUpgradeSupport {
    private static final String SELECT_MAVEN_REPOSITORIES = "select from repository where recipe_name in ['maven2-hosted', 'maven2-proxy']";
    private static final String UPDATE_BUCKET_ATTRIBUTES = "update bucket set attributes.maven_search_index_outdated = true where repository_name in ?";
    private static final String P_REPOSITORY_NAME = "repository_name";
    private final Provider<DatabaseInstance> configDatabaseInstance;
    private final Provider<DatabaseInstance> componentDatabaseInstance;

    public OrientMavenIndexUpgrade(Provider<DatabaseInstance> configDatabaseInstance, Provider<DatabaseInstance> componentDatabaseInstance) {
        this.configDatabaseInstance = (Provider)Preconditions.checkNotNull(configDatabaseInstance);
        this.componentDatabaseInstance = (Provider)Preconditions.checkNotNull(componentDatabaseInstance);
    }

    public void apply() throws Exception {
        if (OrientMavenIndexUpgrade.hasSchemaClass(this.configDatabaseInstance, (String)"repository") && OrientMavenIndexUpgrade.hasSchemaClass(this.componentDatabaseInstance, (String)"bucket")) {
            this.markMavenRepositoriesThatNeedUpdate();
        }
    }

    private void markMavenRepositoriesThatNeedUpdate() {
        List repositoryNames;
        Throwable throwable = null;
        Object var3_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.configDatabaseInstance.get()).connect();){
            repositoryNames = db.query((OQuery)new OSQLSynchQuery(SELECT_MAVEN_REPOSITORIES), new Object[0]).stream().map(d -> (String)d.field(P_REPOSITORY_NAME)).collect(Collectors.toList());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (!repositoryNames.isEmpty()) {
            int updates;
            this.log.info("Marking existing maven repositories as needing search index update ({}).", repositoryNames);
            OCommandSQL updateBucketsCommand = new OCommandSQL(UPDATE_BUCKET_ATTRIBUTES);
            Throwable throwable3 = null;
            Object var5_9 = null;
            try (ODatabaseDocumentTx db = ((DatabaseInstance)this.componentDatabaseInstance.get()).connect();){
                updates = (Integer)db.command((OCommandRequest)updateBucketsCommand).execute(new Object[]{repositoryNames});
            }
            catch (Throwable throwable4) {
                if (throwable3 == null) {
                    throwable3 = throwable4;
                } else if (throwable3 != throwable4) {
                    throwable3.addSuppressed(throwable4);
                }
                throw throwable3;
            }
            this.log.info("Marked {} existing maven repositories as needing search index update.", (Object)updates);
        }
    }
}

