/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.upgrade;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.DependsOn;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.maven.internal.MavenDefaultRepositoriesContributor;

@Named
@Singleton
@Upgrades(model="maven", from="1.3", to="1.4")
@DependsOn(model="config", version="1.9", checkpoint=true)
public class OrientMavenDefaultReposUpgrade_1_4
extends DatabaseUpgradeSupport {
    private static final String P_ATTRIBUTES = "attributes";
    private static final String MAVEN = "maven";
    private static final String FIND_REPO = "SELECT * FROM repository WHERE repository_name = '%s';";
    private static final String UPDATE_REPOS = "UPDATE repository SET attributes.maven.contentDisposition = 'INLINE' WHERE repository_name = '%s';";
    private final MavenDefaultRepositoriesContributor defaultRepositoriesContributor;
    private final Provider<DatabaseInstance> instanceProvider;
    private final List<String> validRecipes;

    @Inject
    public OrientMavenDefaultReposUpgrade_1_4(MavenDefaultRepositoriesContributor defaultRepositoriesContributor, @Named(value="config") @Named(value="config") Provider<DatabaseInstance> instanceProvider) {
        this.defaultRepositoriesContributor = defaultRepositoriesContributor;
        this.instanceProvider = instanceProvider;
        this.validRecipes = Arrays.asList("maven2-hosted", "maven2-proxy");
    }

    public void apply() throws Exception {
        OrientMavenDefaultReposUpgrade_1_4.withDatabase(this.instanceProvider, this::updateRecords);
    }

    private void updateRecords(ODatabaseDocumentTx db) {
        this.defaultRepositoriesContributor.getRepositoryConfigurations().stream().filter(configuration -> this.validRecipes.contains(configuration.getRecipeName())).map(Configuration::getRepositoryName).forEach(name -> this.update(db, (String)name, this.getContentDisposition(db, (String)name)));
    }

    private Optional<String> getContentDisposition(ODatabaseDocumentTx db, String repositoryName) {
        Map attributes = db.query((OQuery)new OSQLSynchQuery(String.format(FIND_REPO, repositoryName)), new Object[0]).stream().map(document -> (Map)document.field(P_ATTRIBUTES, OType.EMBEDDEDMAP)).findFirst().orElse(Collections.emptyMap());
        return Optional.ofNullable((Map)attributes.get(MAVEN)).map(maven -> (String)maven.get("contentDisposition"));
    }

    private void update(ODatabaseDocumentTx db, String repositoryName, Optional<String> contentDisposition) {
        if (!contentDisposition.isPresent()) {
            db.command((OCommandRequest)new OCommandSQL(String.format(UPDATE_REPOS, repositoryName))).execute(new Object[0]);
        }
    }
}

