/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.tasks;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.RepositoryTaskSupport;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.maven.MavenFacet;
import org.sonatype.nexus.repository.maven.RemoveSnapshotsFacet;
import org.sonatype.nexus.repository.maven.VersionPolicy;
import org.sonatype.nexus.repository.maven.tasks.RemoveSnapshotsConfig;
import org.sonatype.nexus.scheduling.TaskConfiguration;

@Named
public class RemoveSnapshotsTask
extends RepositoryTaskSupport {
    private final Format maven2Format;

    @Inject
    public RemoveSnapshotsTask(@Named(value="maven2") @Named(value="maven2") Format maven2Format) {
        this.maven2Format = (Format)Preconditions.checkNotNull((Object)maven2Format);
    }

    protected void execute(Repository repository) {
        if (this.hasBeenProcessed(repository)) {
            this.log.debug("Skipping repository '{}'; it has already been processed", (Object)repository.getName());
            return;
        }
        if (this.isGroupRepository(repository)) {
            this.markProcessed(repository);
            ((GroupFacet)repository.facet(GroupFacet.class)).members().stream().filter(this::appliesTo).forEach(this::execute);
        } else {
            this.log.info("Executing removal of snapshots on repository '{}'", (Object)repository.getName());
            TaskConfiguration config = this.getConfiguration();
            RemoveSnapshotsConfig removeSnapshotsConfig = new RemoveSnapshotsConfig(config.getInteger("minimumRetained", 1), config.getInteger("snapshotRetentionDays", 30), config.getBoolean("removeIfReleased", false), config.getInteger("gracePeriodInDays", -1));
            ((RemoveSnapshotsFacet)repository.facet(RemoveSnapshotsFacet.class)).removeSnapshots(removeSnapshotsConfig);
            this.markProcessed(repository);
        }
    }

    protected boolean appliesTo(Repository repository) {
        return this.maven2Format.equals((Object)repository.getFormat()) && repository.optionalFacet(RemoveSnapshotsFacet.class).isPresent() && ((MavenFacet)repository.facet(MavenFacet.class)).getVersionPolicy() != VersionPolicy.RELEASE;
    }

    public String getMessage() {
        return "Remove Maven snapshots from " + this.getRepositoryField();
    }
}

