/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.tasks;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.RepositoryTaskSupport;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.maven.MavenMetadataRebuildFacet;
import org.sonatype.nexus.scheduling.Cancelable;

@Named
public class RebuildMaven2MetadataTask
extends RepositoryTaskSupport
implements Cancelable {
    private final Type hostedType;
    private final Format maven2Format;

    @Inject
    public RebuildMaven2MetadataTask(@Named(value="hosted") @Named(value="hosted") Type hostedType, @Named(value="maven2") @Named(value="maven2") Format maven2Format) {
        this.hostedType = (Type)Preconditions.checkNotNull((Object)hostedType);
        this.maven2Format = (Format)Preconditions.checkNotNull((Object)maven2Format);
    }

    protected void execute(Repository repository) {
        MavenMetadataRebuildFacet mavenHostedFacet = (MavenMetadataRebuildFacet)repository.facet(MavenMetadataRebuildFacet.class);
        mavenHostedFacet.rebuildMetadata(this.getConfiguration().getString("groupId"), this.getConfiguration().getString("artifactId"), this.getConfiguration().getString("baseVersion"), this.getConfiguration().getBoolean("rebuildChecksums", false), this.getConfiguration().getBoolean("cascadeRebuild", true), false);
    }

    protected boolean appliesTo(Repository repository) {
        return this.maven2Format.equals((Object)repository.getFormat()) && this.hostedType.equals((Object)repository.getType());
    }

    public String getMessage() {
        return "Rebuilding Maven Metadata of " + this.getRepositoryField();
    }
}

