/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.rest;

import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.maven.rest.MavenProxyRepositoryApiRequest;
import org.sonatype.nexus.repository.rest.api.ProxyRepositoryApiRequestToConfigurationConverter;
import org.sonatype.nexus.repository.rest.api.model.ProxyRepositoryApiRequest;
import org.sonatype.nexus.repository.routing.RoutingRuleStore;

@Named
public class MavenProxyRepositoryApiRequestToConfigurationConverter
extends ProxyRepositoryApiRequestToConfigurationConverter<MavenProxyRepositoryApiRequest> {
    private static final String MAVEN = "maven";

    @Inject
    public MavenProxyRepositoryApiRequestToConfigurationConverter(RoutingRuleStore routingRuleStore) {
        super(routingRuleStore);
    }

    public Configuration convert(MavenProxyRepositoryApiRequest request) {
        Configuration configuration = super.convert((ProxyRepositoryApiRequest)request);
        configuration.attributes(MAVEN).set("versionPolicy", (Object)request.getMaven().getVersionPolicy());
        configuration.attributes(MAVEN).set("layoutPolicy", (Object)request.getMaven().getLayoutPolicy());
        configuration.attributes(MAVEN).set("contentDisposition", (Object)request.getMaven().getContentDisposition());
        NestedAttributesMap httpclient = configuration.attributes("httpclient");
        if (Objects.nonNull(httpclient.get("authentication"))) {
            httpclient.child("authentication").set("preemptive", (Object)request.getHttpClient().getAuthentication().isPreemptive());
        }
        return configuration;
    }
}

