/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.search;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.content.maven.internal.search.Maven2ComponentFinder;
import org.sonatype.nexus.repository.search.normalize.VersionNormalizer;
import org.sonatype.nexus.repository.search.normalize.VersionNumberExpander;

@Named(value="maven2")
public class MavenVersionNormalizer
extends ComponentSupport
implements VersionNormalizer {
    private static final int VERSION_LENGTH = 3;
    private static final Pattern ALPHA_PLUS_NUMERIC_PATTERN = Pattern.compile("^([A-Za-z]+)([0-9]+)?(.*)$");
    public static final String ALPHA = "alpha";
    public static final String BETA = "beta";
    public static final String CR = "cr";
    public static final String FINAL = "final";
    public static final String GA = "ga";
    public static final String MILESTONE = "milestone";
    public static final String RELEASE = "release";
    public static final String RC = "rc";
    public static final String SP = "sp";

    public String getNormalizedVersion(String originalVersion) {
        if (Strings2.isBlank((String)originalVersion)) {
            return "";
        }
        String trimmedVersion = originalVersion.trim();
        String[] result = this.splitQualifier(trimmedVersion);
        String version = result[0];
        String qualifier = result[1];
        String[] versionList = version.split("\\.");
        if (!this.isRecognizedFormat(versionList)) {
            return VersionNumberExpander.expand((String)trimmedVersion);
        }
        versionList = this.fillMissingParts(versionList);
        qualifier = this.standardizeQualifier(qualifier);
        return this.getNormalizedValue(versionList, qualifier, trimmedVersion);
    }

    private String[] fillMissingParts(String[] parts) {
        if (parts.length == 3) {
            return parts;
        }
        String[] result = new String[3];
        int i = 0;
        while (i < 3) {
            result[i] = i < parts.length ? parts[i] : "0";
            ++i;
        }
        return result;
    }

    private String[] splitQualifier(String version) {
        String v = null;
        String q = null;
        int i = 0;
        while (v == null && i < version.length()) {
            char c = version.charAt(i);
            if (c != '.' && !Character.isDigit(c)) {
                v = version.substring(0, i);
                q = version.substring(c == '-' ? i + 1 : i);
            }
            ++i;
        }
        return new String[]{v != null ? v : version, q};
    }

    private String standardizeQualifier(String originalQualifier) {
        if (originalQualifier == null) {
            return null;
        }
        String qualifier = originalQualifier.toLowerCase();
        if (qualifier.startsWith(CR)) {
            qualifier = RC + qualifier.substring(2);
        }
        return this.standardizeAlphaPlusNumericQualifier(qualifier);
    }

    private String standardizeAlphaPlusNumericQualifier(String qualifier) {
        Matcher matcher = ALPHA_PLUS_NUMERIC_PATTERN.matcher(qualifier);
        if (matcher.find()) {
            String alphaPart = matcher.group(1);
            String numberPart = matcher.group(2);
            String suffix = matcher.group(3);
            if (numberPart != null && !numberPart.equals("")) {
                if (alphaPart.equals("a")) {
                    alphaPart = ALPHA;
                } else if (alphaPart.equals("b")) {
                    alphaPart = BETA;
                } else if (alphaPart.equals("m")) {
                    alphaPart = MILESTONE;
                }
                String result = String.valueOf(alphaPart) + "-" + numberPart;
                if (!suffix.equals("")) {
                    result = String.valueOf(result) + "-" + suffix;
                }
                return result;
            }
        }
        return qualifier;
    }

    private QualifierType getQualifierType(String qualifier, String originalVersion) {
        if (Strings2.isBlank((String)qualifier) || qualifier.equals(GA) || qualifier.equals(RELEASE) || qualifier.equals(FINAL)) {
            return QualifierType.RELEASE;
        }
        if (Maven2ComponentFinder.SNAPSHOT_TIMESTAMP.matcher(originalVersion).matches()) {
            return QualifierType.SNAPSHOT;
        }
        if (qualifier.startsWith(ALPHA) || qualifier.startsWith(BETA) || qualifier.startsWith(MILESTONE) || qualifier.startsWith(RC)) {
            return QualifierType.BEFORE_RELEASE;
        }
        if (qualifier.startsWith(SP)) {
            return QualifierType.AFTER_RELEASE;
        }
        if (Character.isDigit(qualifier.charAt(0))) {
            return QualifierType.BUILD_NUMBER;
        }
        return QualifierType.UNKNOWN;
    }

    private String getNormalizedValue(String[] versionList, String qualifier, String originalVersion) {
        QualifierType type = this.getQualifierType(qualifier, originalVersion);
        String v = String.valueOf(String.join((CharSequence)".", versionList)) + "." + type.getKey();
        if (type != QualifierType.RELEASE) {
            v = String.valueOf(v) + "." + qualifier;
        }
        return VersionNumberExpander.expand((String)v);
    }

    private boolean isRecognizedFormat(String[] versionList) {
        return versionList.length > 0 && versionList.length <= 3 && !Strings2.isBlank((String)versionList[0]);
    }

    private static enum QualifierType {
        BEFORE_RELEASE("a"),
        SNAPSHOT("b"),
        RELEASE("c"),
        AFTER_RELEASE("d"),
        UNKNOWN("e"),
        BUILD_NUMBER("f");

        private final String key;

        private QualifierType(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

