/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.orient.importtask;

import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.importtask.ImportPostProcessor;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.StorageTx;

@Singleton
@Named(value="maven2")
public class OrientMavenImportPostProcessor
implements ImportPostProcessor {
    public void attributePostProcessing(Asset asset, StorageTx tx, Repository repository) {
        MavenPath.HashType[] hashTypeArray = MavenPath.HashType.values();
        int n = hashTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MavenPath.HashType type = hashTypeArray[n2];
            this.updateHashFile(String.valueOf('.') + type.getExt(), asset, tx, repository);
            ++n2;
        }
    }

    private void updateHashFile(String hashFileExtension, Asset asset, StorageTx tx, Repository repository) {
        Asset hashAsset = tx.findAssetWithProperty("name", (Object)(String.valueOf(asset.name()) + hashFileExtension), tx.findBucket(repository));
        if (hashAsset != null) {
            this.updateHashFileDates(hashAsset, asset, tx);
        }
    }

    private void updateHashFileDates(Asset hashAsset, Asset asset, StorageTx tx) {
        boolean assetTouched = false;
        if (hashAsset.blobUpdated() == null || hashAsset.blobUpdated() != null && !hashAsset.blobUpdated().equals((Object)asset.blobUpdated())) {
            hashAsset.blobUpdated(asset.blobUpdated());
            assetTouched = true;
        }
        if (hashAsset.blobCreated() == null || hashAsset.blobCreated() != null && !hashAsset.blobCreated().equals((Object)asset.blobCreated())) {
            hashAsset.blobCreated(asset.blobCreated());
            assetTouched = true;
        }
        if (hashAsset.lastDownloaded() == null || hashAsset.lastDownloaded() != null && !hashAsset.lastDownloaded().equals((Object)asset.lastDownloaded())) {
            hashAsset.lastDownloaded(asset.lastDownloaded());
            assetTouched = true;
        }
        if (hashAsset.lastUpdated() == null || hashAsset.lastUpdated() != null && !hashAsset.lastUpdated().equals((Object)asset.lastUpdated())) {
            hashAsset.lastUpdated(asset.lastUpdated());
            assetTouched = true;
        }
        if (assetTouched) {
            tx.saveAsset(hashAsset);
        }
    }
}

