/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.elasticsearch.search.lookup.SourceLookup;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.MavenPathParser;
import org.sonatype.nexus.repository.maven.internal.utils.MavenVariableResolverAdapterUtil;
import org.sonatype.nexus.repository.search.AssetSearchResult;
import org.sonatype.nexus.repository.search.ComponentSearchResult;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetVariableResolverSupport;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.selector.VariableSourceBuilder;

@Named(value="maven2")
@Singleton
public class OrientMavenVariableResolverAdapter
extends AssetVariableResolverSupport {
    private final MavenPathParser mavenPathParser;

    @Inject
    public OrientMavenVariableResolverAdapter(@Named(value="maven2") @Named(value="maven2") MavenPathParser mavenPathParser) {
        this.mavenPathParser = (MavenPathParser)Preconditions.checkNotNull((Object)mavenPathParser);
    }

    protected void addFromRequest(VariableSourceBuilder builder, Request request) {
        this.addMavenCoordinates(builder, request.getPath());
    }

    protected void addFromDocument(VariableSourceBuilder builder, ODocument document) {
        this.addMavenCoordinates(builder, (String)document.field("name", String.class));
    }

    protected void addFromAsset(VariableSourceBuilder builder, Asset asset) {
        this.addMavenCoordinates(builder, asset.name());
    }

    protected void addFromSourceLookup(VariableSourceBuilder builder, SourceLookup sourceLookup, Map<String, Object> asset) {
        this.addMavenCoordinates(builder, (String)asset.get("name"));
    }

    protected void addFromSearchResults(VariableSourceBuilder builder, ComponentSearchResult component, AssetSearchResult asset) {
        this.addMavenCoordinates(builder, asset.getPath());
    }

    private void addMavenCoordinates(VariableSourceBuilder builder, String path) {
        Preconditions.checkNotNull((Object)builder);
        Preconditions.checkNotNull((Object)path);
        MavenPath.Coordinates coords = this.mavenPathParser.parsePath(path).getCoordinates();
        if (coords != null) {
            this.addCoordinates(builder, MavenVariableResolverAdapterUtil.createCoordinateMap(coords));
        }
    }
}

