/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.orient;

import java.io.IOException;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.maven.MavenIndexFacet;
import org.sonatype.nexus.repository.maven.internal.MavenIndexPublisher;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.transaction.UnitOfWork;

public abstract class OrientMavenIndexFacetSupport
extends FacetSupport
implements MavenIndexFacet {
    final MavenIndexPublisher mavenIndexPublisher;

    OrientMavenIndexFacetSupport(MavenIndexPublisher mavenIndexPublisher) {
        this.mavenIndexPublisher = mavenIndexPublisher;
    }

    @Override
    @Nullable
    public DateTime lastPublished() throws IOException {
        UnitOfWork.begin((Supplier)((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier());
        try {
            DateTime dateTime = this.mavenIndexPublisher.lastPublished(this.getRepository());
            return dateTime;
        }
        finally {
            UnitOfWork.end();
        }
    }

    @Override
    public void unpublishIndex() throws IOException {
        UnitOfWork.begin((Supplier)((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier());
        try {
            this.mavenIndexPublisher.unpublishIndexFiles(this.getRepository());
        }
        finally {
            UnitOfWork.end();
        }
    }
}

