/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.orient;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.function.Supplier;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.index.reader.Record;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.maven.internal.MavenIndexPublisher;
import org.sonatype.nexus.repository.maven.internal.filter.DuplicateDetectionStrategy;
import org.sonatype.nexus.repository.maven.internal.filter.DuplicateDetectionStrategyProvider;
import org.sonatype.nexus.repository.maven.internal.orient.OrientMavenIndexFacetSupport;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Priority(value=0x7FFFFFFF)
public class OrientMavenGroupIndexFacet
extends OrientMavenIndexFacetSupport {
    private final DuplicateDetectionStrategyProvider duplicateDetectionStrategyProvider;

    @Inject
    public OrientMavenGroupIndexFacet(DuplicateDetectionStrategyProvider duplicateDetectionStrategyProvider, MavenIndexPublisher mavenIndexPublisher) {
        super(mavenIndexPublisher);
        this.duplicateDetectionStrategyProvider = (DuplicateDetectionStrategyProvider)((Object)Preconditions.checkNotNull((Object)((Object)duplicateDetectionStrategyProvider)));
    }

    @Override
    public void publishIndex() throws IOException {
        UnitOfWork.begin((Supplier)((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier());
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Object strategy = this.duplicateDetectionStrategyProvider.get();){
                this.mavenIndexPublisher.publishGroupIndex(this.getRepository(), ((GroupFacet)this.facet(GroupFacet.class)).leafMembers(), (DuplicateDetectionStrategy<Record>)strategy);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            UnitOfWork.end();
        }
    }
}

