/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.orient;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.browse.BrowsePaths;
import org.sonatype.nexus.repository.browse.ComponentPathBrowseNodeGenerator;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;

@Singleton
@Named(value="maven2")
@Priority(value=0x7FFFFFFF)
public class OrientMaven2BrowseNodeGenerator
extends ComponentPathBrowseNodeGenerator {
    public List<BrowsePaths> computeAssetPaths(Asset asset, @Nullable Component component) {
        Preconditions.checkNotNull((Object)asset);
        if (component != null) {
            List<BrowsePaths> paths = this.computeComponentPaths(asset, component);
            String lastSegment = this.lastSegment(asset.name());
            BrowsePaths.appendPath(paths, (String)lastSegment);
            return paths;
        }
        return super.computeAssetPaths(asset, null);
    }

    public List<BrowsePaths> computeComponentPaths(Asset asset, Component component) {
        ArrayList<String> pathParts = new ArrayList<String>();
        if (!Strings2.isBlank((String)component.group())) {
            pathParts.addAll(Splitter.on((char)'.').omitEmptyStrings().splitToList((CharSequence)component.group()));
        }
        pathParts.add(component.name());
        List paths = BrowsePaths.fromPaths(pathParts, (boolean)true);
        if (!Strings2.isBlank((String)component.version())) {
            String baseVersion = (String)component.attributes().child("maven2").get("baseVersion", String.class);
            String requestPath = String.valueOf(((BrowsePaths)paths.get(paths.size() - 1)).getRequestPath()) + baseVersion + "/";
            if (!component.version().equals(baseVersion)) {
                BrowsePaths.appendPath((List)paths, (String)baseVersion, (String)requestPath);
            }
            BrowsePaths.appendPath((List)paths, (String)component.version(), (String)requestPath);
        }
        return paths;
    }
}

