/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.orient;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.orient.maven.OrientMavenFacet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.maven.MavenHostedFacet;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.internal.orient.MavenFacetUtils;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;

@Singleton
@Named
public class OrientArchetypeCatalogHandler
extends ComponentSupport
implements Handler {
    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        String action;
        MavenPath path = (MavenPath)context.getAttributes().require(MavenPath.class);
        Repository repository = context.getRepository();
        switch (action = context.getRequest().getAction()) {
            case "GET": 
            case "HEAD": {
                return this.doGet(path, repository);
            }
        }
        return HttpResponses.methodNotAllowed((String)context.getRequest().getAction(), (String[])new String[]{"GET", "HEAD"});
    }

    private Response doGet(MavenPath path, Repository repository) throws IOException {
        OrientMavenFacet mavenFacet = (OrientMavenFacet)repository.facet(OrientMavenFacet.class);
        Content content = mavenFacet.get(path);
        if (content == null) {
            ((MavenHostedFacet)repository.facet(MavenHostedFacet.class)).rebuildArchetypeCatalog();
            content = mavenFacet.get(path);
            if (content == null) {
                return HttpResponses.notFound((String)path.getPath());
            }
        }
        AttributesMap attributesMap = content.getAttributes();
        MavenFacetUtils.mayAddETag(attributesMap, MavenFacetUtils.getHashAlgorithmFromContent(attributesMap));
        return HttpResponses.ok((Payload)content);
    }
}

