/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.orient;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.orient.maven.OrientMavenFacet;
import org.sonatype.nexus.repository.maven.MavenHostedFacet;
import org.sonatype.nexus.repository.maven.internal.orient.MavenComponentMaintenanceFacet;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.DefaultComponentMaintenanceImpl;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class MavenHostedComponentMaintenanceFacet
extends MavenComponentMaintenanceFacet {
    @TransactionalDeleteBlob
    protected DefaultComponentMaintenanceImpl.DeletionResult deleteComponentTx(EntityId componentId, boolean deleteBlobs) {
        DefaultComponentMaintenanceImpl.DeletionResult result = super.deleteComponentTx(componentId, deleteBlobs);
        Component component = result.getComponent();
        if (component != null) {
            String groupId = (String)component.formatAttributes().get("groupId", String.class);
            String artifactId = (String)component.formatAttributes().get("artifactId", String.class);
            String baseVersion = (String)component.formatAttributes().get("baseVersion", String.class);
            Set<String> deletedMetadataPaths = ((MavenHostedFacet)this.getRepository().facet(MavenHostedFacet.class)).deleteMetadata(groupId, artifactId, baseVersion);
            result.getAssets().addAll(deletedMetadataPaths);
        }
        return result;
    }

    @TransactionalDeleteBlob
    protected DefaultComponentMaintenanceImpl.DeletionProgress doBatchDelete(List<EntityId> entityIds, BooleanSupplier cancelledCheck) {
        try {
            List<String[]> gavs = this.collectGavs(entityIds);
            OrientMavenFacet mavenFacet = (OrientMavenFacet)this.getRepository().facet(OrientMavenFacet.class);
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            Bucket bucket = tx.findBucket(this.getRepository());
            DefaultComponentMaintenanceImpl.DeletionProgress batchProgress = this.deleteComponentBatch(entityIds, cancelledCheck);
            for (String[] gav : gavs) {
                mavenFacet.maybeDeleteOrFlagToRebuildMetadata(bucket, gav[0], gav[1], gav[2]);
                mavenFacet.maybeDeleteOrFlagToRebuildMetadata(bucket, gav[0], gav[1]);
                mavenFacet.maybeDeleteOrFlagToRebuildMetadata(bucket, gav[0]);
            }
            return batchProgress;
        }
        catch (Exception ex) {
            this.log.debug("Error encountered attempting to delete components for repository {}.", (Object)this.getRepository().getName(), (Object)ex);
            return new DefaultComponentMaintenanceImpl.DeletionProgress();
        }
    }

    @Transactional
    protected List<String[]> collectGavs(List<EntityId> entityIds) {
        return entityIds.stream().map(this::findComponent).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    private String[] findComponent(EntityId entityId) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Component component = tx.findComponentInBucket(entityId, tx.findBucket(this.getRepository()));
        if (component != null) {
            return new String[]{(String)component.formatAttributes().get("groupId", String.class), (String)component.formatAttributes().get("artifactId", String.class), (String)component.formatAttributes().get("baseVersion", String.class)};
        }
        return null;
    }
}

