/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.orient;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Named;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.DefaultComponentMaintenanceImpl;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class MavenComponentMaintenanceFacet
extends DefaultComponentMaintenanceImpl {
    @TransactionalDeleteBlob
    protected Set<String> deleteAssetTx(EntityId assetId, boolean deleteBlob) {
        Component component;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = tx.findAsset(assetId);
        if (asset == null) {
            return Collections.emptySet();
        }
        HashSet<String> deletedAssets = new HashSet<String>(super.deleteAssetTx(assetId, deleteBlob));
        EntityId componentId = asset.componentId();
        if (componentId != null && (component = tx.findComponent(componentId)) != null && !tx.browseAssets(component).iterator().hasNext()) {
            deletedAssets.addAll(this.deleteComponentTx(componentId, deleteBlob).getAssets());
        }
        return deletedAssets;
    }
}

