/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.matcher;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.MavenPathParser;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Matcher;

public class MavenMatcherSupport
extends ComponentSupport
implements Matcher {
    private final MavenPathParser mavenPathParser;
    private final Predicate<String> predicate;

    public static Predicate<String> withHashes(Predicate<String> predicate) {
        return input -> {
            String mainPath = input;
            MavenPath.HashType[] hashTypeArray = MavenPath.HashType.values();
            int n = hashTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                MavenPath.HashType hashType = hashTypeArray[n2];
                if (mainPath.endsWith("." + hashType.getExt())) {
                    mainPath = mainPath.substring(0, mainPath.length() - (hashType.getExt().length() + 1));
                    break;
                }
                ++n2;
            }
            return predicate.apply((Object)mainPath);
        };
    }

    public MavenMatcherSupport(MavenPathParser mavenPathParser, Predicate<String> predicate) {
        this.mavenPathParser = (MavenPathParser)Preconditions.checkNotNull((Object)mavenPathParser);
        this.predicate = (Predicate)Preconditions.checkNotNull(predicate);
    }

    public boolean matches(Context context) {
        String path = context.getRequest().getPath();
        if (this.predicate.apply((Object)path)) {
            MavenPath mavenPath = this.mavenPathParser.parsePath(path);
            context.getAttributes().set(MavenPath.class, (Object)mavenPath);
            return true;
        }
        return false;
    }
}

