/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.hosted.metadata;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nullable;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.internal.MavenModels;

public final class MetadataUtils {
    private static final Logger log = LoggerFactory.getLogger(MetadataUtils.class);

    private MetadataUtils() {
    }

    public static MavenPath metadataPath(String groupId, @Nullable String artifactId, @Nullable String baseVersion) {
        StringBuilder sb = new StringBuilder();
        sb.append(groupId.replace('.', '/'));
        if (artifactId != null) {
            sb.append("/").append(artifactId);
            if (baseVersion != null) {
                sb.append("/").append(baseVersion);
            }
        }
        sb.append("/").append("maven-metadata.xml");
        return new MavenPath(sb.toString(), null);
    }

    public static String getPluginPrefix(MavenPath mavenPath, InputStreamSupplier inputSupplier) {
        String prefix;
        block15: {
            Preconditions.checkArgument((mavenPath.getCoordinates() != null ? 1 : 0) != 0);
            Preconditions.checkArgument((boolean)Objects.equals(mavenPath.getCoordinates().getExtension(), "jar"));
            prefix = null;
            try {
                if (inputSupplier == null) break block15;
                Throwable throwable = null;
                Object var4_6 = null;
                try (ZipInputStream zip = new ZipInputStream(inputSupplier.get());){
                    ZipEntry entry;
                    while ((entry = zip.getNextEntry()) != null) {
                        if (!entry.isDirectory() && "META-INF/maven/plugin.xml".equals(entry.getName())) {
                            Xpp3Dom dom = MavenModels.parseDom(zip);
                            prefix = MetadataUtils.getChildValue(dom, "goalPrefix", null);
                            break;
                        }
                        zip.closeEntry();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                log.warn("Unable to read plugin.xml of {}", (Object)mavenPath, (Object)e);
            }
        }
        if (prefix != null) {
            return prefix;
        }
        if ("maven-plugin-plugin".equals(mavenPath.getCoordinates().getArtifactId())) {
            return "plugin";
        }
        return mavenPath.getCoordinates().getArtifactId().replaceAll("-?maven-?", "").replaceAll("-?plugin-?", "");
    }

    private static String getChildValue(Xpp3Dom doc, String childName, String defaultValue) {
        Xpp3Dom child = doc.getChild(childName);
        if (child == null) {
            return defaultValue;
        }
        return child.getValue();
    }
}

