/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.hosted.metadata;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionScheme;
import org.joda.time.DateTime;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.Maven2Metadata;

public class MetadataBuilder
extends ComponentSupport {
    private final VersionScheme versionScheme = new GenericVersionScheme();
    private String groupId;
    private String artifactId;
    private String baseVersion;
    private final List<Maven2Metadata.Plugin> plugins = new ArrayList<Maven2Metadata.Plugin>();
    private final NavigableSet<Version> baseVersions = new TreeSet<Version>();
    private final Map<String, VersionCoordinates> latestVersionCoordinatesMap = new HashMap<String, VersionCoordinates>();
    private VersionCoordinates latestVersionCoordinates;

    public boolean onEnterGroupId(String groupId) {
        Preconditions.checkNotNull((Object)groupId);
        if (Objects.equals(groupId, this.groupId)) {
            return false;
        }
        this.groupId = groupId;
        this.artifactId = null;
        this.baseVersion = null;
        this.plugins.clear();
        this.log.debug("-> G: {}", (Object)groupId);
        return true;
    }

    @Nullable
    public Maven2Metadata onExitGroupId() {
        Preconditions.checkState((this.groupId != null ? 1 : 0) != 0);
        this.log.debug("<- G: {}", (Object)this.groupId);
        if (this.plugins.isEmpty()) {
            this.log.debug("No plugins in group: {}", (Object)this.groupId);
            return null;
        }
        return Maven2Metadata.newGroupLevel(DateTime.now(), this.plugins);
    }

    public boolean addPlugin(String prefix, String artifactId, String name) {
        Maven2Metadata.Plugin plugin = Maven2Metadata.newPlugin(artifactId, prefix, name);
        Iterator<Maven2Metadata.Plugin> pi = this.plugins.iterator();
        while (pi.hasNext()) {
            Maven2Metadata.Plugin p = pi.next();
            if (plugin.equals(p)) {
                return false;
            }
            if (!plugin.keyEquals(p)) continue;
            pi.remove();
            break;
        }
        this.plugins.add(plugin);
        this.log.debug("Added plugin {}:{} prefix:{}", new Object[]{this.groupId, artifactId, prefix});
        return true;
    }

    public boolean onEnterArtifactId(String artifactId) {
        Preconditions.checkState((this.groupId != null ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)artifactId);
        if (Objects.equals(artifactId, this.artifactId)) {
            return false;
        }
        this.artifactId = artifactId;
        this.baseVersion = null;
        this.baseVersions.clear();
        this.log.debug("-> GA: {}:{}", (Object)this.groupId, (Object)artifactId);
        return true;
    }

    @Nullable
    public Maven2Metadata onExitArtifactId() {
        String latest;
        Preconditions.checkState((this.artifactId != null ? 1 : 0) != 0);
        this.log.debug("<- GA: {}:{}", (Object)this.groupId, (Object)this.artifactId);
        if (this.baseVersions.isEmpty()) {
            this.log.debug("Nothing to generate: {}:{}", (Object)this.groupId, (Object)this.artifactId);
            return null;
        }
        Iterator<Version> vi = this.baseVersions.descendingIterator();
        String release = latest = vi.next().toString();
        while (release.endsWith("SNAPSHOT") && vi.hasNext()) {
            release = vi.next().toString();
        }
        if (release.endsWith("SNAPSHOT")) {
            release = null;
        }
        return Maven2Metadata.newArtifactLevel(DateTime.now(), this.groupId, this.artifactId, latest, release, Iterables.transform(this.baseVersions, (Function)new Function<Version, String>(){

            public String apply(Version input) {
                return input.toString();
            }
        }));
    }

    public void addBaseVersion(String baseVersion) {
        Preconditions.checkNotNull((Object)baseVersion);
        try {
            if (this.baseVersions.add(this.versionScheme.parseVersion(baseVersion))) {
                this.log.debug("Added base version {}:{}:{}", new Object[]{this.groupId, this.artifactId, baseVersion});
            }
        }
        catch (InvalidVersionSpecificationException e) {
            this.log.info("Invalid baseVersion discovered: " + baseVersion, (Throwable)e);
        }
    }

    public boolean onEnterBaseVersion(String baseVersion) {
        Preconditions.checkState((this.groupId != null ? 1 : 0) != 0);
        Preconditions.checkState((this.artifactId != null ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)baseVersion);
        if (Objects.equals(baseVersion, this.baseVersion)) {
            return false;
        }
        this.baseVersion = baseVersion;
        this.latestVersionCoordinatesMap.clear();
        this.latestVersionCoordinates = null;
        this.log.debug("-> GAbV: {}:{}:{}", new Object[]{this.groupId, this.artifactId, baseVersion});
        return true;
    }

    @Nullable
    public Maven2Metadata onExitBaseVersion() {
        Preconditions.checkState((this.baseVersion != null ? 1 : 0) != 0);
        this.log.debug("<- GAbV: {}:{}:{}", new Object[]{this.groupId, this.artifactId, this.baseVersion});
        if (!this.baseVersion.endsWith("SNAPSHOT")) {
            this.log.debug("Not a snapshot or nothing to generate: {}:{}:{}", new Object[]{this.groupId, this.artifactId, this.baseVersion});
            return null;
        }
        if (this.latestVersionCoordinates == null) {
            return Maven2Metadata.newNonUniqueVersionLevel(this.groupId, this.artifactId, this.baseVersion);
        }
        ArrayList<Maven2Metadata.Snapshot> snapshots = new ArrayList<Maven2Metadata.Snapshot>();
        for (VersionCoordinates versionCoordinates : this.latestVersionCoordinatesMap.values()) {
            MavenPath.Coordinates coordinates = versionCoordinates.coordinates;
            Maven2Metadata.Snapshot snapshotVersion = Maven2Metadata.newSnapshot(new DateTime((Object)coordinates.getTimestamp()), coordinates.getExtension(), coordinates.getClassifier(), coordinates.getVersion());
            snapshots.add(snapshotVersion);
        }
        return Maven2Metadata.newVersionLevel(DateTime.now(), this.groupId, this.artifactId, this.baseVersion, this.latestVersionCoordinates.coordinates.getTimestamp(), this.latestVersionCoordinates.coordinates.getBuildNumber(), snapshots);
    }

    public void addArtifactVersion(MavenPath mavenPath) {
        String key;
        VersionCoordinates other;
        Preconditions.checkNotNull((Object)mavenPath);
        MavenPath.Coordinates coordinates = mavenPath.getCoordinates();
        if (mavenPath.isSubordinate() || coordinates == null) {
            return;
        }
        String path = mavenPath.getPath();
        Preconditions.checkState((boolean)Objects.equals(this.groupId, coordinates.getGroupId()), (String)"GroupId:%s Path:%s", (Object)this.groupId, (Object)path);
        Preconditions.checkState((boolean)Objects.equals(this.artifactId, coordinates.getArtifactId()), (String)"ArtifactId:%s Path:%s", (Object)this.artifactId, (Object)path);
        Preconditions.checkState((boolean)Objects.equals(this.baseVersion, coordinates.getBaseVersion()), (String)"Version:%s Path:%s", (Object)this.baseVersion, (Object)path);
        this.log.debug("Discovered {}:{}:{}:{}:{}", new Object[]{coordinates.getGroupId(), coordinates.getArtifactId(), coordinates.getVersion(), coordinates.getClassifier(), coordinates.getExtension()});
        this.addBaseVersion(coordinates.getBaseVersion());
        if (!coordinates.isSnapshot()) {
            return;
        }
        if (Objects.equals(coordinates.getBaseVersion(), coordinates.getVersion())) {
            this.log.debug("Non-timestamped snapshot, ignoring it: {}", (Object)mavenPath);
            return;
        }
        Version version = this.parseVersion(coordinates.getVersion());
        if (version == null) {
            return;
        }
        VersionCoordinates versionCoordinates = new VersionCoordinates(version, coordinates);
        if (this.latestVersionCoordinates == null || this.latestVersionCoordinates.version.compareTo((Object)version) < 0) {
            this.latestVersionCoordinates = versionCoordinates;
        }
        if ((other = this.latestVersionCoordinatesMap.get(key = this.key(coordinates))) == null || other.version.compareTo((Object)versionCoordinates.version) < 0) {
            this.latestVersionCoordinatesMap.put(key, versionCoordinates);
        }
    }

    private String key(MavenPath.Coordinates coordinates) {
        if (coordinates.getClassifier() == null) {
            return coordinates.getExtension();
        }
        return String.valueOf(coordinates.getExtension()) + ":" + coordinates.getClassifier();
    }

    @Nullable
    private Version parseVersion(String version) {
        try {
            return this.versionScheme.parseVersion(version);
        }
        catch (InvalidVersionSpecificationException e) {
            this.log.warn("Invalid version: {}", (Object)version, (Object)e);
            return null;
        }
    }

    private static class VersionCoordinates {
        private final Version version;
        private final MavenPath.Coordinates coordinates;

        private VersionCoordinates(Version version, MavenPath.Coordinates coordinates) {
            this.version = version;
            this.coordinates = coordinates;
        }
    }
}

