/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.hosted.metadata;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class Maven2Metadata {
    private final Level level;
    private final DateTime lastUpdated;
    @Nullable
    private final String groupId;
    @Nullable
    private final String artifactId;
    @Nullable
    private final String version;
    @Nullable
    private final List<Plugin> plugins;
    @Nullable
    private final BaseVersions baseVersions;
    @Nullable
    private final Snapshots snapshots;

    private Maven2Metadata(Level level, DateTime lastUpdated, @Nullable String groupId, @Nullable String artifactId, @Nullable String version, @Nullable List<Plugin> plugins, @Nullable BaseVersions baseVersions, @Nullable Snapshots snapshots) {
        this.level = level;
        this.lastUpdated = lastUpdated;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.plugins = plugins != null ? ImmutableList.copyOf(plugins) : null;
        this.baseVersions = baseVersions;
        this.snapshots = snapshots;
    }

    public Level getLevel() {
        return this.level;
    }

    public DateTime getLastUpdated() {
        return this.lastUpdated;
    }

    @Nullable
    public String getGroupId() {
        return this.groupId;
    }

    @Nullable
    public String getArtifactId() {
        return this.artifactId;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    @Nullable
    public BaseVersions getBaseVersions() {
        return this.baseVersions;
    }

    @Nullable
    public Snapshots getSnapshots() {
        return this.snapshots;
    }

    public static Plugin newPlugin(String artifactId, String prefix, String name) {
        Preconditions.checkNotNull((Object)artifactId);
        Preconditions.checkNotNull((Object)prefix);
        return new Plugin(artifactId, prefix, Strings.isNullOrEmpty((String)name) ? artifactId : name);
    }

    public static Maven2Metadata newGroupLevel(DateTime lastUpdated, List<Plugin> plugins) {
        Preconditions.checkNotNull((Object)lastUpdated);
        Preconditions.checkNotNull(plugins);
        return new Maven2Metadata(Level.GROUP, lastUpdated, null, null, null, plugins, null, null);
    }

    public static Maven2Metadata newArtifactLevel(DateTime lastUpdated, String groupId, String artifactId, String latest, @Nullable String release, Iterable<String> versions) {
        Preconditions.checkNotNull((Object)lastUpdated);
        Preconditions.checkNotNull((Object)groupId);
        Preconditions.checkNotNull((Object)artifactId);
        Preconditions.checkNotNull((Object)latest);
        Preconditions.checkNotNull(versions);
        BaseVersions bvs = new BaseVersions(latest, release, versions);
        return new Maven2Metadata(Level.ARTIFACT, lastUpdated, groupId, artifactId, null, null, bvs, null);
    }

    public static Snapshot newSnapshot(DateTime lastUpdated, String extension, @Nullable String classifier, String version) {
        Preconditions.checkNotNull((Object)lastUpdated);
        Preconditions.checkNotNull((Object)extension);
        Preconditions.checkNotNull((Object)version);
        return new Snapshot(lastUpdated, extension, classifier, version);
    }

    public static Maven2Metadata newVersionLevel(DateTime lastUpdated, String groupId, String artifactId, String version, long snapshotTimestamp, int snapshotBuildNumber, @Nullable List<Snapshot> snapshots) {
        Preconditions.checkNotNull((Object)lastUpdated);
        Preconditions.checkNotNull((Object)groupId);
        Preconditions.checkNotNull((Object)artifactId);
        Preconditions.checkNotNull((Object)version);
        Preconditions.checkArgument((snapshotTimestamp > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((snapshotBuildNumber > 0 ? 1 : 0) != 0);
        Snapshots snaps = new Snapshots(snapshotTimestamp, snapshotBuildNumber, snapshots);
        return new Maven2Metadata(Level.BASEVERSION, lastUpdated, groupId, artifactId, version, null, null, snaps);
    }

    public static Maven2Metadata newNonUniqueVersionLevel(String groupId, String artifactId, String version) {
        Preconditions.checkNotNull((Object)groupId);
        Preconditions.checkNotNull((Object)artifactId);
        Preconditions.checkNotNull((Object)version);
        Snapshots snaps = new Snapshots(null, 1, null);
        return new Maven2Metadata(Level.BASEVERSION, DateTime.now(), groupId, artifactId, version, null, null, snaps);
    }

    public String toString() {
        return "Maven2Metadata{level=" + (Object)((Object)this.level) + ", lastUpdated=" + this.lastUpdated + ", groupId='" + this.groupId + '\'' + ", artifactId='" + this.artifactId + '\'' + ", version='" + this.version + '\'' + ", plugins=" + this.plugins + ", baseVersions=" + this.baseVersions + ", snapshots=" + this.snapshots + '}';
    }

    public static class BaseVersions {
        private final String latest;
        @Nullable
        private final String release;
        private final List<String> versions;

        private BaseVersions(String latest, @Nullable String release, Iterable<String> versions) {
            this.latest = latest;
            this.release = release;
            this.versions = ImmutableList.copyOf(versions);
        }

        public String getLatest() {
            return this.latest;
        }

        @Nullable
        public String getRelease() {
            return this.release;
        }

        public List<String> getVersions() {
            return this.versions;
        }

        public String toString() {
            return "BaseVersions{latest='" + this.latest + '\'' + ", release='" + this.release + '\'' + ", versions=" + this.versions + '}';
        }
    }

    public static enum Level {
        GROUP,
        ARTIFACT,
        BASEVERSION;

    }

    public static class Plugin {
        private final String artifactId;
        private final String prefix;
        private final String name;

        private Plugin(String artifactId, String prefix, String name) {
            this.artifactId = artifactId;
            this.prefix = prefix;
            this.name = name;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getName() {
            return this.name;
        }

        public boolean keyEquals(Plugin o) {
            return this.artifactId.equals(o.artifactId) && this.prefix.equals(o.prefix);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Plugin)) {
                return false;
            }
            Plugin plugin = (Plugin)o;
            if (!this.artifactId.equals(plugin.artifactId)) {
                return false;
            }
            if (!this.prefix.equals(plugin.prefix)) {
                return false;
            }
            return this.name.equals(plugin.name);
        }

        public int hashCode() {
            int result = this.artifactId.hashCode();
            result = 31 * result + this.prefix.hashCode();
            result = 31 * result + this.name.hashCode();
            return result;
        }

        public String toString() {
            return "Plugin{artifactId='" + this.artifactId + '\'' + ", prefix='" + this.prefix + '\'' + ", name='" + this.name + '\'' + '}';
        }
    }

    public static class Snapshot {
        private final DateTime lastUpdated;
        private final String extension;
        @Nullable
        private final String classifier;
        private final String version;

        private Snapshot(DateTime lastUpdated, String extension, @Nullable String classifier, String version) {
            this.lastUpdated = lastUpdated;
            this.extension = extension;
            this.classifier = classifier;
            this.version = version;
        }

        public DateTime getLastUpdated() {
            return this.lastUpdated;
        }

        public String getExtension() {
            return this.extension;
        }

        @Nullable
        public String getClassifier() {
            return this.classifier;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Snapshot)) {
                return false;
            }
            Snapshot snapshot = (Snapshot)o;
            if (!this.lastUpdated.equals((Object)snapshot.lastUpdated)) {
                return false;
            }
            if (!this.extension.equals(snapshot.extension)) {
                return false;
            }
            if (!Objects.equals(this.classifier, snapshot.classifier)) {
                return false;
            }
            return this.version.equals(snapshot.version);
        }

        public int hashCode() {
            int result = this.lastUpdated.hashCode();
            result = 31 * result + this.extension.hashCode();
            result = 31 * result + (this.classifier != null ? this.classifier.hashCode() : 0);
            result = 31 * result + this.version.hashCode();
            return result;
        }

        public String toString() {
            return "Snapshot{lastUpdated=" + this.lastUpdated + ", extension='" + this.extension + '\'' + ", classifier='" + this.classifier + '\'' + ", version='" + this.version + '\'' + '}';
        }
    }

    public static class Snapshots {
        private final Long snapshotTimestamp;
        private final int snapshotBuildNumber;
        private final List<Snapshot> snapshots;

        private Snapshots(@Nullable Long snapshotTimestamp, int snapshotBuildNumber, @Nullable List<Snapshot> snapshots) {
            this.snapshotTimestamp = snapshotTimestamp;
            this.snapshotBuildNumber = snapshotBuildNumber;
            this.snapshots = snapshots != null ? ImmutableList.copyOf(snapshots) : Collections.emptyList();
        }

        @Nullable
        public Long getSnapshotTimestamp() {
            return this.snapshotTimestamp;
        }

        public int getSnapshotBuildNumber() {
            return this.snapshotBuildNumber;
        }

        public List<Snapshot> getSnapshots() {
            return this.snapshots;
        }

        public String toString() {
            return "Snapshots{timestamp=" + this.snapshotTimestamp + ", buildNumber=" + this.snapshotBuildNumber + ", snapshots=" + this.snapshots + '}';
        }
    }
}

