/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.hosted.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.hash.HashCode;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.common.MultipleFailures;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.MavenPathParser;
import org.sonatype.nexus.repository.maven.internal.DigestExtractor;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.AbstractMetadataUpdater;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.Maven2Metadata;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.MetadataBuilder;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.MetadataException;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.MetadataRebuilder;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.MetadataUtils;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;
import org.sonatype.nexus.scheduling.CancelableHelper;

public abstract class AbstractMetadataRebuilder
extends ComponentSupport
implements MetadataRebuilder {
    protected final int bufferSize;
    protected final int timeoutSeconds;

    @Inject
    public AbstractMetadataRebuilder(@Named(value="${nexus.maven.metadata.rebuild.bufferSize:-1000}") @Named(value="${nexus.maven.metadata.rebuild.bufferSize:-1000}") int bufferSize, @Named(value="${nexus.maven.metadata.rebuild.timeoutSeconds:-60}") @Named(value="${nexus.maven.metadata.rebuild.timeoutSeconds:-60}") int timeoutSeconds) {
        this.bufferSize = bufferSize;
        this.timeoutSeconds = timeoutSeconds;
    }

    protected List<MavenPath> getPathsByGav(Repository repository, String groupId, String artifactId, String baseVersion) {
        Preconditions.checkNotNull((Object)groupId);
        Preconditions.checkNotNull((Object)artifactId);
        Preconditions.checkNotNull((Object)baseVersion);
        this.log.debug("Collecting MavenPaths for Maven2 hosted repository metadata: repository={}, g={}, a={}, bV={}", new Object[]{repository.getName(), groupId, artifactId, baseVersion});
        ArrayList<MavenPath> paths = new ArrayList<MavenPath>();
        paths.add(MetadataUtils.metadataPath(groupId, artifactId, baseVersion));
        paths.add(MetadataUtils.metadataPath(groupId, artifactId, null));
        MavenPath groupPath = MetadataUtils.metadataPath(groupId, null, null);
        if (this.exists(repository, groupPath)) {
            paths.add(groupPath);
        }
        return paths;
    }

    protected Set<String> deleteAllMetadataFiles(Repository repository, String groupId, String artifactId, String baseVersion) {
        HashSet deletedPaths = Sets.newHashSet();
        deletedPaths.addAll(this.deleteGavMetadata(repository, groupId, artifactId, baseVersion));
        deletedPaths.addAll(this.deleteGavMetadata(repository, groupId, artifactId, null));
        deletedPaths.addAll(this.deleteGavMetadata(repository, groupId, null, null));
        return deletedPaths;
    }

    protected abstract Set<String> deleteGavMetadata(Repository var1, String var2, String var3, String var4);

    public abstract boolean exists(Repository var1, MavenPath var2);

    protected static abstract class Worker
    extends ComponentSupport {
        protected final Repository repository;
        protected final MavenPathParser mavenPathParser;
        protected final MetadataBuilder metadataBuilder;
        protected final AbstractMetadataUpdater metadataUpdater;
        protected final String groupId;
        protected final String artifactId;
        protected final String baseVersion;
        protected final boolean rebuildChecksums;
        protected final int bufferSize;
        protected final long timeoutSeconds;

        public Worker(Repository repository, boolean update, boolean rebuildChecksums, @Nullable String groupId, @Nullable String artifactId, @Nullable String baseVersion, int bufferSize, int timeoutSeconds, AbstractMetadataUpdater metadataUpdater, MavenPathParser mavenPathParser) {
            this.repository = repository;
            this.metadataBuilder = new MetadataBuilder();
            this.metadataUpdater = metadataUpdater;
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.baseVersion = baseVersion;
            this.rebuildChecksums = rebuildChecksums;
            this.bufferSize = bufferSize;
            this.timeoutSeconds = timeoutSeconds;
            this.mavenPathParser = mavenPathParser;
        }

        protected abstract List<Map<String, Object>> browseGAVs();

        protected abstract Content get(MavenPath var1) throws IOException;

        protected abstract void put(MavenPath var1, Payload var2) throws IOException;

        public boolean rebuildMetadata() {
            MultipleFailures failures = new MultipleFailures();
            boolean metadataRebuilt = false;
            CancelableHelper.checkCancellation();
            String currentGroupId = null;
            try {
                List<Map<String, Object>> gavs = this.browseGAVs();
                this.log.debug("Beginning metadata rebuild for {} GAVs", (Object)gavs.size());
                if (!gavs.isEmpty() && Objects.nonNull(this.groupId)) {
                    this.log.debug("Rebuilding Group: {}", (Object)this.groupId);
                    this.metadataBuilder.onEnterGroupId(this.groupId);
                    if (Objects.nonNull(this.artifactId) && Objects.nonNull(this.baseVersion)) {
                        this.log.debug("Rebuilding Group: {} Artifact: {}", (Object)this.groupId, (Object)this.artifactId);
                        this.rebuildMetadataInner(this.groupId, this.artifactId, Collections.emptySet(), failures);
                    }
                    this.rebuildMetadataExitGroup(this.groupId, failures);
                }
                for (Map<String, Object> gav : gavs) {
                    boolean groupChange;
                    CancelableHelper.checkCancellation();
                    String groupId = (String)gav.get("groupId");
                    String artifactId = (String)gav.get("artifactId");
                    Set baseVersions = (Set)gav.get("baseVersions");
                    this.log.debug("Group: {} Artifact: {} Base versions: {}", new Object[]{groupId, artifactId, baseVersions});
                    boolean bl = groupChange = !Objects.equals(currentGroupId, groupId);
                    if (groupChange) {
                        if (currentGroupId != null) {
                            this.rebuildMetadataExitGroup(currentGroupId, failures);
                        }
                        currentGroupId = groupId;
                        this.metadataBuilder.onEnterGroupId(groupId);
                    }
                    this.rebuildMetadataInner(groupId, artifactId, baseVersions, failures);
                    metadataRebuilt = true;
                }
                if (currentGroupId != null) {
                    this.rebuildMetadataExitGroup(currentGroupId, failures);
                    metadataRebuilt = true;
                }
            }
            finally {
                this.maybeLogFailures(failures);
            }
            return metadataRebuilt;
        }

        public boolean refreshMetadata() {
            MultipleFailures failures = new MultipleFailures();
            CancelableHelper.checkCancellation();
            String prevGroupId = null;
            boolean rebuilt = false;
            try {
                List<Map<String, Object>> gavs = this.browseGAVs();
                this.log.debug("Beginning metadata refresh for {} GAVs", (Object)gavs.size());
                if (!gavs.isEmpty() && Objects.nonNull(this.groupId)) {
                    this.log.debug("Refreshing Group: {}", (Object)this.groupId);
                    this.metadataBuilder.onEnterGroupId(this.groupId);
                    if (Objects.nonNull(this.artifactId) && Objects.nonNull(this.baseVersion)) {
                        this.log.debug("Refreshing Group: {} Artifact: {}", (Object)this.groupId, (Object)this.artifactId);
                        this.refreshArtifact(this.groupId, this.artifactId, Collections.emptySet(), failures);
                    }
                    this.rebuildMetadataExitGroup(this.groupId, failures);
                }
                for (Map<String, Object> gav : gavs) {
                    boolean groupChange;
                    CancelableHelper.checkCancellation();
                    String g = (String)gav.get("groupId");
                    String a = (String)gav.get("artifactId");
                    Set bv = (Set)gav.get("baseVersions");
                    this.log.debug("Group: {} Artifact: {} Base versions: {}", new Object[]{g, a, bv});
                    boolean bl = groupChange = !Objects.equals(prevGroupId, g);
                    if (groupChange) {
                        if (prevGroupId != null) {
                            this.rebuildMetadataExitGroup(prevGroupId, failures);
                        }
                        prevGroupId = g;
                        this.metadataBuilder.onEnterGroupId(g);
                    }
                    boolean rebuildGA = this.refreshArtifact(g, a, bv, failures);
                    boolean bl2 = rebuilt = rebuilt || rebuildGA;
                }
                if (prevGroupId != null) {
                    this.rebuildMetadataExitGroup(prevGroupId, failures);
                    rebuilt = true;
                }
            }
            finally {
                this.maybeLogFailures(failures);
            }
            this.log.debug("Finished metadata refresh. Rebuilt {}", (Object)rebuilt);
            return rebuilt;
        }

        protected void maybeLogFailures(MultipleFailures failures) {
            if (failures.isEmpty()) {
                return;
            }
            this.log.warn("Errors encountered during metadata rebuild:");
            failures.getFailures().forEach(failure -> this.log.warn(failure.getMessage(), failure));
        }

        protected void rebuildMetadataExitGroup(String currentGroupId, MultipleFailures failures) {
            this.processMetadata(MetadataUtils.metadataPath(currentGroupId, null, null), this.metadataBuilder.onExitGroupId(), failures);
        }

        protected void processMetadata(MavenPath metadataPath, Maven2Metadata metadata, MultipleFailures failures) {
            try {
                this.metadataUpdater.processMetadata(metadataPath, metadata);
            }
            catch (Exception e) {
                failures.add((Throwable)new MetadataException("Error processing metadata for path: " + metadataPath.getPath(), e));
            }
        }

        protected abstract void rebuildMetadataInner(String var1, String var2, Set<String> var3, MultipleFailures var4);

        protected abstract boolean refreshArtifact(String var1, String var2, Set<String> var3, MultipleFailures var4);

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected boolean mayUpdateChecksum(MavenPath mavenPath, MavenPath.HashType hashType) {
            MavenPath checksumPath;
            String assetChecksum;
            block13: {
                Optional<HashCode> checksum = this.getChecksum(mavenPath, hashType);
                if (!checksum.isPresent()) {
                    this.log.warn("Asset with path {} lacks checksum {}", (Object)mavenPath, (Object)hashType);
                    return false;
                }
                assetChecksum = checksum.get().toString();
                checksumPath = mavenPath.hash(hashType);
                try {
                    Content content = this.get(checksumPath);
                    if (content == null) break block13;
                    Throwable throwable = null;
                    Object var8_11 = null;
                    try (InputStream is = content.openInputStream();){
                        String mavenChecksum = DigestExtractor.extract(is);
                        if (Objects.equals(assetChecksum, mavenChecksum)) {
                            return false;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                            throw throwable;
                        }
                        if (throwable == throwable2) throw throwable;
                        throwable.addSuppressed(throwable2);
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    this.log.warn("Error reading {}", (Object)checksumPath, (Object)e);
                }
            }
            try {
                this.log.debug("Generating checksum file: {}", (Object)checksumPath);
                StringPayload mavenChecksum = new StringPayload(assetChecksum, "text/plain");
                this.put(checksumPath, (Payload)mavenChecksum);
                return true;
            }
            catch (IOException e) {
                this.log.warn("Error writing {}", (Object)checksumPath, (Object)e);
                throw new RuntimeException(e);
            }
        }

        protected abstract Optional<HashCode> getChecksum(MavenPath var1, MavenPath.HashType var2);
    }
}

