/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.group;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.IOException;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.cooperation2.Cooperation2;
import org.sonatype.nexus.common.cooperation2.Cooperation2Factory;
import org.sonatype.nexus.common.cooperation2.IOCall;
import org.sonatype.nexus.repository.HasFacet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.group.GroupHandler;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.internal.group.MavenGroupFacet;
import org.sonatype.nexus.repository.proxy.ProxyFacet;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.transaction.RetryDeniedException;

@Singleton
@Named
public class MergingGroupHandler
extends GroupHandler {
    private static final Predicate<Repository> PROXY_OR_GROUP = Predicates.or((Predicate)new HasFacet(ProxyFacet.class), (Predicate)new HasFacet(GroupFacet.class));
    private Cooperation2 metadataCooperation;

    @Inject
    public MergingGroupHandler(Cooperation2Factory cooperationFactory, @Named(value="${nexus.maven.group.cooperation.enabled:-true}") @Named(value="${nexus.maven.group.cooperation.enabled:-true}") boolean cooperationEnabled, @Named(value="${nexus.maven.group.cooperation.majorTimeout:-0s}") @Named(value="${nexus.maven.group.cooperation.majorTimeout:-0s}") Duration majorTimeout, @Named(value="${nexus.maven.group.cooperation.minorTimeout:-30s}") @Named(value="${nexus.maven.group.cooperation.minorTimeout:-30s}") Duration minorTimeout, @Named(value="${nexus.maven.group.cooperation.threadsPerKey:-100}") @Named(value="${nexus.maven.group.cooperation.threadsPerKey:-100}") int threadsPerKey) {
        this.metadataCooperation = cooperationFactory.configure().majorTimeout(majorTimeout).minorTimeout(minorTimeout).threadsPerKey(threadsPerKey).enabled(cooperationEnabled).build(((Object)((Object)this)).getClass(), new String[0]);
    }

    protected Response doGetHash(@Nonnull Context context) throws Exception {
        MavenPath mavenPath = (MavenPath)context.getAttributes().require(MavenPath.class);
        MavenGroupFacet groupFacet = (MavenGroupFacet)context.getRepository().facet(MavenGroupFacet.class);
        Repository repository = context.getRepository();
        this.log.trace("Incoming request for {} : {}", (Object)context.getRepository().getName(), (Object)mavenPath.getPath());
        MavenPath parentPath = mavenPath.subordinateOf();
        Context copyContext = context.copy(oldAttributes -> {
            AttributesMap newAttributes = new AttributesMap();
            oldAttributes.backing().forEach((arg_0, arg_1) -> ((AttributesMap)newAttributes).set(arg_0, arg_1));
            newAttributes.set(MavenPath.class, (Object)parentPath);
            return newAttributes;
        }, requestBuilder -> {
            requestBuilder.path(parentPath.getPath());
            AttributesMap oldAttributes = requestBuilder.attributes();
            AttributesMap newAttributes = new AttributesMap();
            oldAttributes.backing().forEach((arg_0, arg_1) -> ((AttributesMap)newAttributes).set(arg_0, arg_1));
            newAttributes.set(MavenPath.class, (Object)parentPath);
            requestBuilder.attributes(newAttributes);
            return requestBuilder;
        });
        this.doGet(copyContext, new GroupHandler.DispatchedRepositories());
        Optional<Content> cachedContent = this.checkCache(groupFacet, mavenPath, repository);
        if (cachedContent.isPresent()) {
            this.log.trace("Serving cached content {} : {}", (Object)repository.getName(), (Object)mavenPath.getPath());
            return HttpResponses.ok((Payload)((Payload)cachedContent.get()));
        }
        this.log.trace("Outbound request for hash {} : {}", (Object)repository.getName(), (Object)mavenPath.getPath());
        return HttpResponses.notFound();
    }

    private Response doGetContent(@Nonnull Context context, @Nonnull GroupHandler.DispatchedRepositories dispatched) throws Exception {
        MavenPath mavenPath = (MavenPath)context.getAttributes().require(MavenPath.class);
        MavenGroupFacet groupFacet = (MavenGroupFacet)context.getRepository().facet(MavenGroupFacet.class);
        Repository repository = context.getRepository();
        List members = groupFacet.members();
        this.log.trace("Incoming request for {} : {}", (Object)context.getRepository().getName(), (Object)mavenPath.getPath());
        List proxiesOrGroups = members.stream().filter(arg_0 -> PROXY_OR_GROUP.apply(arg_0)).collect(Collectors.toList());
        Content content = (Content)this.maybeCooperate(repository, mavenPath, () -> {
            try {
                LinkedHashMap passThroughResponses = this.getAll(context, proxiesOrGroups, dispatched);
                Optional<Content> cached = this.checkCache(groupFacet, mavenPath, repository);
                if (cached.isPresent()) {
                    this.log.trace("Serving cached content {} : {}", (Object)repository.getName(), (Object)mavenPath.getPath());
                    return cached.get();
                }
                LinkedHashMap remainingResponses = this.getAll(context, members, dispatched);
                LinkedHashMap<Repository, Response> responses = new LinkedHashMap<Repository, Response>();
                for (Repository member : members) {
                    Response response = (Response)passThroughResponses.get(member);
                    if (response == null) {
                        response = (Response)remainingResponses.get(member);
                    }
                    if (response == null) continue;
                    responses.put(member, response);
                }
                Content mergedContent = groupFacet.mergeAndCache(mavenPath, responses);
                if (mergedContent != null) {
                    this.log.trace("Responses merged {} : {}", (Object)context.getRepository().getName(), (Object)mavenPath.getPath());
                }
                return mergedContent;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        });
        if (content != null) {
            return HttpResponses.ok((Payload)content);
        }
        this.log.trace("Not found response to merge {} : {}", (Object)repository.getName(), (Object)mavenPath.getPath());
        return HttpResponses.notFound();
    }

    private Optional<Content> checkCache(@Nonnull MavenGroupFacet groupFacet, @Nonnull MavenPath mavenPath, @Nonnull Repository repository) throws IOException {
        try {
            return Optional.ofNullable(groupFacet.getCached(mavenPath));
        }
        catch (RetryDeniedException e) {
            this.log.debug("Conflict fetching cached content {} : {}", new Object[]{repository.getName(), mavenPath.getPath(), e});
            return Optional.empty();
        }
    }

    protected Response doGet(@Nonnull Context context, @Nonnull GroupHandler.DispatchedRepositories dispatched) throws Exception {
        MavenPath mavenPath = (MavenPath)context.getAttributes().require(MavenPath.class);
        if (mavenPath.isHash()) {
            return this.doGetHash(context);
        }
        return this.doGetContent(context, dispatched);
    }

    private <T> T maybeCooperate(Repository repository, MavenPath path, IOCall<T> call) throws IOException {
        return (T)this.metadataCooperation.on(call).cooperate(repository.getName(), new String[]{path.toString()});
    }
}

