/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.filter;

import com.google.common.base.Preconditions;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.index.reader.Record;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.repository.maven.internal.filter.BloomFilterDuplicateDetectionStrategy;
import org.sonatype.nexus.repository.maven.internal.filter.DiskBackedDuplicateDetectionStrategy;
import org.sonatype.nexus.repository.maven.internal.filter.DuplicateDetectionStrategy;
import org.sonatype.nexus.repository.maven.internal.filter.HashBasedDuplicateDetectionStrategy;

@Singleton
@Named
public class DuplicateDetectionStrategyProvider
extends ComponentSupport
implements Provider<DuplicateDetectionStrategy<Record>> {
    private final String strategy;
    private final ApplicationDirectories applicationDirectories;
    private final int maxHeapGb;
    private final int maxDiskSizeGb;

    @Inject
    public DuplicateDetectionStrategyProvider(ApplicationDirectories applicationDirectories, @Named(value="${nexus.maven.duplicate.detection.strategy:-BLOOM}") @Named(value="${nexus.maven.duplicate.detection.strategy:-BLOOM}") String strategy, @Named(value="${nexus.maven.duplicate.detection.heap.max.gb:-1}") @Named(value="${nexus.maven.duplicate.detection.heap.max.gb:-1}") int maxHeapGb, @Named(value="${nexus.maven.duplicate.detection.disk.max.gb:-10}") @Named(value="${nexus.maven.duplicate.detection.disk.max.gb:-10}") int maxDiskSizeGb) {
        this.applicationDirectories = (ApplicationDirectories)Preconditions.checkNotNull((Object)applicationDirectories);
        this.strategy = (String)Preconditions.checkNotNull((Object)strategy);
        this.maxHeapGb = maxHeapGb;
        this.maxDiskSizeGb = maxDiskSizeGb;
    }

    public DuplicateDetectionStrategy<Record> get() {
        switch (this.getStrategy()) {
            case HASH: {
                return new HashBasedDuplicateDetectionStrategy();
            }
            case DISK: {
                return new DiskBackedDuplicateDetectionStrategy(this.applicationDirectories, this.maxHeapGb, this.maxDiskSizeGb);
            }
        }
        return new BloomFilterDuplicateDetectionStrategy();
    }

    private Strategy getStrategy() {
        Strategy duplicateStrategy = null;
        try {
            duplicateStrategy = Strategy.valueOf(this.strategy.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.warn("Unsupported record duplicate detection strategy {}. Falling back to bloom. ", (Object)duplicateStrategy);
            duplicateStrategy = Strategy.BLOOM;
        }
        return duplicateStrategy;
    }

    private static enum Strategy {
        HASH,
        BLOOM,
        DISK;

    }
}

