/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.elastic;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.elasticsearch.search.SearchHit;
import org.sonatype.nexus.repository.search.ComponentSearchResult;
import org.sonatype.nexus.repository.search.elasticsearch.OrientSearchExtension;

@Singleton
@Named(value="maven2")
public class Maven2OrientSearchExtension
implements OrientSearchExtension {
    public void updateComponent(ComponentSearchResult component, SearchHit hit) {
        if ("maven2".equals(component.getFormat())) {
            Maven2OrientSearchExtension.getBaseVersion(hit).ifPresent(baseVersion -> component.addAnnotation("baseVersion", baseVersion));
        }
    }

    private static Optional<String> getBaseVersion(SearchHit hit) {
        Map source = (Map)Preconditions.checkNotNull((Object)hit.getSource());
        return Optional.ofNullable(source.get("attributes")).filter(attrs -> attrs instanceof Map).map(Map.class::cast).map(attrs -> attrs.get("maven2")).filter(attrs -> attrs instanceof Map).map(Map.class::cast).map(attrs -> attrs.get("baseVersion")).filter(baseVersion -> baseVersion instanceof String).map(String.class::cast);
    }
}

