/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.content.importtask;

import java.time.OffsetDateTime;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.importtask.ImportPostProcessor;
import org.sonatype.nexus.repository.maven.MavenPath;

@Singleton
@Named(value="maven2")
public class MavenImportPostProcessor
extends ComponentSupport
implements ImportPostProcessor {
    public void attributePostProcessing(Repository repository, Asset asset) {
        MavenPath.HashType[] hashTypeArray = MavenPath.HashType.values();
        int n = hashTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MavenPath.HashType type = hashTypeArray[n2];
            this.updateHashFile(String.valueOf('.') + type.getExt(), asset, repository);
            ++n2;
        }
    }

    private void updateHashFile(String hashFileExtension, Asset asset, Repository repository) {
        Optional hashAsset = ((ContentFacet)repository.facet(ContentFacet.class)).assets().path(String.valueOf(asset.path()) + hashFileExtension).find();
        if (hashAsset.isPresent()) {
            this.updateHashFileDates((FluentAsset)hashAsset.get(), asset);
        }
    }

    private void updateHashFileDates(FluentAsset hashAsset, Asset asset) {
        Optional lastDownloaded = hashAsset.lastDownloaded();
        if (!lastDownloaded.isPresent() || !((OffsetDateTime)lastDownloaded.get()).equals(asset.lastDownloaded().orElse(null))) {
            hashAsset.lastDownloaded((OffsetDateTime)asset.lastDownloaded().orElse(null));
        }
        if (!hashAsset.created().equals(asset.created())) {
            hashAsset.created(asset.created());
        }
        if (hashAsset.lastUpdated() == null || hashAsset.lastUpdated() != null && !hashAsset.lastUpdated().equals(asset.lastUpdated())) {
            hashAsset.lastUpdated(asset.lastUpdated());
        }
        hashAsset.blob().ifPresent(blob -> asset.blob().ifPresent(assetBlob2 -> {
            if (blob.blobCreated() == null || blob.blobCreated() != null && !blob.blobCreated().equals(assetBlob2.blobCreated())) {
                hashAsset.blobCreated(assetBlob2.blobCreated());
            }
        }));
    }
}

