/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.content;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.common.MultipleFailures;
import org.sonatype.nexus.content.maven.MavenContentFacet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.internal.content.MetadataRebuildWorker;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.MetadataRebuilder;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.MetadataUtils;
import org.sonatype.nexus.thread.ExceptionAwareThreadFactory;

@Singleton
@Named
public class MavenMetadataRebuilder
extends ComponentSupport
implements MetadataRebuilder {
    private static final String PATH_PREFIX = "/";
    private final int bufferSize;
    private final ExecutorService executor;

    @Inject
    public MavenMetadataRebuilder(@Named(value="${nexus.maven.metadata.rebuild.bufferSize:-1000}") @Named(value="${nexus.maven.metadata.rebuild.bufferSize:-1000}") int bufferSize, @Named(value="${nexus.maven.metadata.rebuild.threadPoolSize:-1}") @Named(value="${nexus.maven.metadata.rebuild.threadPoolSize:-1}") int maxTreads) {
        Preconditions.checkArgument((bufferSize > 0 ? 1 : 0) != 0, (Object)"Buffer size must be greater than 0");
        this.bufferSize = bufferSize;
        this.executor = Executors.newFixedThreadPool(maxTreads, (ThreadFactory)new ExceptionAwareThreadFactory("metadata-rebuild-tasks", "metadata-rebuild-tasks"));
    }

    @Override
    public boolean rebuild(Repository repository, boolean update, boolean rebuildChecksums, boolean cascadeUpdate, @Nullable String groupId, @Nullable String artifactId, @Nullable String baseVersion) {
        Preconditions.checkNotNull((Object)repository);
        MetadataRebuildWorker worker = new MetadataRebuildWorker(repository, update, groupId, artifactId, baseVersion, this.bufferSize);
        return this.rebuildWithWorker(worker, rebuildChecksums, cascadeUpdate, groupId, artifactId, baseVersion);
    }

    @VisibleForTesting
    boolean rebuildWithWorker(MetadataRebuildWorker worker, boolean rebuildChecksums, boolean cascadeUpdate, @Nullable String groupId, @Nullable String artifactId, @Nullable String baseVersion) {
        boolean rebuiltMetadata = false;
        try {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{groupId, artifactId})) {
                Collection<String> baseVersions = worker.rebuildGA(groupId, artifactId);
                if (StringUtils.isNotBlank((CharSequence)baseVersion)) {
                    worker.rebuildBaseVersionsAndChecksums(groupId, artifactId, Collections.singletonList(baseVersion), rebuildChecksums);
                } else if (cascadeUpdate) {
                    this.rebuildBaseVersionsAndChecksumsAsync(worker, groupId, artifactId, baseVersions, rebuildChecksums);
                }
            } else {
                rebuiltMetadata = worker.rebuildMetadata();
                if (rebuildChecksums) {
                    worker.rebuildChecksums();
                }
            }
        }
        finally {
            this.maybeLogFailures(worker.getFailures());
        }
        return rebuiltMetadata;
    }

    @Override
    @Deprecated
    public boolean rebuildInTransaction(Repository repository, boolean update, boolean rebuildChecksums, boolean cascadeUpdate, @Nullable String groupId, @Nullable String artifactId, @Nullable String baseVersion) {
        return this.rebuild(repository, update, rebuildChecksums, cascadeUpdate, groupId, artifactId, baseVersion);
    }

    @Override
    public Set<String> deleteMetadata(Repository repository, List<String[]> gavs) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull(gavs);
        ArrayList paths = Lists.newArrayList();
        for (String[] gav : gavs) {
            MavenPath mavenPath = MetadataUtils.metadataPath(gav[0], gav[1], gav[2]);
            paths.add(StringUtils.prependIfMissing((String)mavenPath.main().getPath(), (CharSequence)PATH_PREFIX, (CharSequence[])new CharSequence[0]));
            MavenPath.HashType[] hashTypeArray = MavenPath.HashType.values();
            int n = hashTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                MavenPath.HashType hashType = hashTypeArray[n2];
                paths.add(StringUtils.prependIfMissing((String)mavenPath.main().hash(hashType).getPath(), (CharSequence)PATH_PREFIX, (CharSequence[])new CharSequence[0]));
                ++n2;
            }
        }
        MavenContentFacet mavenContentFacet = (MavenContentFacet)repository.facet(MavenContentFacet.class);
        HashSet deletedPaths = Sets.newHashSet();
        if (mavenContentFacet.delete(paths)) {
            deletedPaths.addAll(paths);
        }
        return deletedPaths;
    }

    private void rebuildBaseVersionsAndChecksumsAsync(MetadataRebuildWorker worker, String namespace, String name, Collection<String> baseVersions, boolean rebuildChecksums) {
        this.executor.submit(() -> {
            this.log.debug("Started asynchronously rebuild metadata/recalculate checksums for GAVs. Namespace: {}, name: {}, baseVersions {}", new Object[]{namespace, name, baseVersions});
            worker.rebuildBaseVersionsAndChecksums(namespace, name, baseVersions, rebuildChecksums);
            this.log.debug("Finished asynchronously rebuild metadata/recalculate checksums for GAVs. Namespace: {}, name: {}, baseVersions {}", new Object[]{namespace, name, baseVersions});
        });
    }

    private void maybeLogFailures(MultipleFailures failures) {
        if (failures.isEmpty()) {
            return;
        }
        this.log.warn("Errors encountered during metadata rebuild:");
        failures.getFailures().forEach(failure -> this.log.warn(failure.getMessage(), failure));
    }
}

