/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.content;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.sonatype.nexus.content.maven.MavenContentFacet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.internal.MavenModels;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.AbstractMetadataUpdater;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

public class DatastoreMetadataUpdater
extends AbstractMetadataUpdater {
    public DatastoreMetadataUpdater(boolean update, Repository repository) {
        super(update, repository);
    }

    @Override
    protected void write(MavenPath mavenPath, Metadata metadata) throws IOException {
        MavenContentFacet mavenContentFacet = (MavenContentFacet)this.repository.facet(MavenContentFacet.class);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        MavenModels.writeMetadata(buffer, metadata);
        mavenContentFacet.put(mavenPath, (Payload)new BytesPayload(buffer.toByteArray(), "application/xml"));
        Optional<Map> hashCodes = mavenContentFacet.assets().path("/" + mavenPath.getPath()).find().flatMap(Asset::blob).map(AssetBlob::checksums);
        Preconditions.checkState((boolean)hashCodes.isPresent(), (Object)"hashCodes");
        MavenPath.HashType[] hashTypeArray = MavenPath.HashType.values();
        int n = hashTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MavenPath.HashType hashType = hashTypeArray[n2];
            MavenPath checksumPath = mavenPath.hash(hashType);
            String hashCode = (String)hashCodes.get().get(hashType.getHashAlgorithm().name());
            Preconditions.checkState((hashCode != null ? 1 : 0) != 0, (String)"hashCode: type=%s", (Object)((Object)hashType));
            mavenContentFacet.put(checksumPath, (Payload)new StringPayload(hashCode, "text/plain"));
            ++n2;
        }
    }

    @Override
    protected Optional<Metadata> read(MavenPath mavenPath) throws IOException {
        return ((MavenContentFacet)this.repository.facet(MavenContentFacet.class)).get(mavenPath).map(content -> {
            Metadata metadata = null;
            try {
                metadata = MavenModels.readMetadata(content.openInputStream());
            }
            catch (IOException iOException) {
                this.log.warn("Corrupted metadata {} @ {}", (Object)this.repository.getName(), (Object)mavenPath.getPath());
            }
            return metadata;
        });
    }

    @Override
    protected void delete(MavenPath mavenPath) {
        Preconditions.checkNotNull((Object)this.repository);
        Preconditions.checkNotNull((Object)mavenPath);
        try {
            ((MavenContentFacet)this.repository.facet(MavenContentFacet.class)).deleteWithHashes(mavenPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

