/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.attributes;

import java.util.Map;
import java.util.TreeMap;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.application.scan.AttributesCoordinatesAdapter;

@Named(value="maven2")
@Singleton
public class Maven2AttributesCoordinatesAdapter
implements AttributesCoordinatesAdapter {
    private static final String WILDCARD = "*";

    public Map<String, String> toCoordinates(NestedAttributesMap attributes) {
        TreeMap<String, String> coordinates = new TreeMap<String, String>();
        coordinates.put("groupId", (String)attributes.get("groupId", String.class));
        coordinates.put("artifactId", (String)attributes.get("artifactId", String.class));
        coordinates.put("version", (String)attributes.get("version", String.class));
        coordinates.put("classifier", (String)attributes.get("classifier", String.class));
        coordinates.put("extension", (String)attributes.get("extension", String.class));
        return coordinates;
    }

    public Map<String, String> toArtifactCoordinates(Map<String, String> coordinates) {
        TreeMap<String, String> artifactCoordinates = new TreeMap<String, String>(coordinates);
        artifactCoordinates.put("classifier", WILDCARD);
        artifactCoordinates.put("extension", WILDCARD);
        return artifactCoordinates;
    }
}

