/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.catalog.io.xpp3.ArchetypeCatalogXpp3Reader;
import org.apache.maven.archetype.catalog.io.xpp3.ArchetypeCatalogXpp3Writer;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Writer;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MavenModels {
    private static final Logger log = LoggerFactory.getLogger(MavenModels.class);
    private static final MetadataXpp3Reader METADATA_READER = new MetadataXpp3Reader();
    private static final MetadataXpp3Writer METADATA_WRITER = new MetadataXpp3Writer();
    private static final ArchetypeCatalogXpp3Reader ARCHETYPE_CATALOG_READER = new ArchetypeCatalogXpp3Reader();
    private static final ArchetypeCatalogXpp3Writer ARCHETYPE_CATALOG_WRITER = new ArchetypeCatalogXpp3Writer();
    private static final MavenXpp3Reader MODEL_READER = new MavenXpp3Reader();

    private MavenModels() {
    }

    public static Xpp3Dom parseDom(InputStream is) throws IOException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
                return Xpp3DomBuilder.build((Reader)reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (XmlPullParserException e) {
            log.debug("Could not parse XML into Xpp3Dom", (Throwable)e);
            throw new IOException("Could not parse XML into Xpp3Dom", e);
        }
    }

    @Nullable
    public static Metadata readMetadata(InputStream inputStream) throws IOException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream is = inputStream;){
                return METADATA_READER.read(is, false);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (EOFException | XmlPullParserException e) {
            log.debug("Could not parse XML into Metadata", e);
            return null;
        }
    }

    public static void writeMetadata(OutputStream outputStream, Metadata metadata) throws IOException {
        METADATA_WRITER.write(outputStream, metadata);
    }

    @Nullable
    public static ArchetypeCatalog readArchetypeCatalog(InputStream inputStream) throws IOException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream is = inputStream;){
                return ARCHETYPE_CATALOG_READER.read(is, false);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (EOFException | XmlPullParserException e) {
            log.debug("Could not parse XML into ArchetypeCatalog", e);
            return null;
        }
    }

    public static void writeArchetypeCatalog(OutputStream outputStream, ArchetypeCatalog archetypeCatalog) throws IOException {
        ARCHETYPE_CATALOG_WRITER.write(outputStream, archetypeCatalog);
    }

    @Nullable
    public static Model readModel(InputStream inputStream) throws IOException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream is = inputStream;){
                return MODEL_READER.read(is, false);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (EOFException | XmlPullParserException e) {
            log.debug("Could not parse XML into Model", e);
            return null;
        }
    }
}

