/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.mime.MimeRule;
import org.sonatype.nexus.mime.MimeRulesSource;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.internal.Maven2MavenPathParser;

@Named(value="maven2")
@Singleton
public class MavenMimeRulesSource
extends ComponentSupport
implements MimeRulesSource {
    public static final String POM_TYPE = "application/xml";
    private static final MimeRule POM_RULE = new MimeRule(true, new String[]{"application/xml"});
    public static final String HASH_TYPE = "text/plain";
    private static final MimeRule HASH_RULE = new MimeRule(true, new String[]{"text/plain"});
    public static final String METADATA_TYPE = "application/xml";
    private static final MimeRule METADATA_RULE = new MimeRule(true, new String[]{"application/xml"});
    public static final String SIGNATURE_TYPE = "application/pgp-signature";
    private static final MimeRule SIGNATURE_RULE = new MimeRule(true, new String[]{"application/pgp-signature", "text/plain"});
    private final Maven2MavenPathParser mavenPathParser;

    @Inject
    public MavenMimeRulesSource(Maven2MavenPathParser mavenPathParser) {
        this.mavenPathParser = (Maven2MavenPathParser)Preconditions.checkNotNull((Object)mavenPathParser);
    }

    @Nullable
    public MimeRule getRuleForName(String name) {
        MavenPath mavenPath = this.mavenPathParser.parsePath(name);
        if (mavenPath.isPom()) {
            return POM_RULE;
        }
        if (mavenPath.isHash()) {
            return HASH_RULE;
        }
        if (mavenPath.isSignature()) {
            return SIGNATURE_RULE;
        }
        if ("maven-metadata.xml".equals(mavenPath.getFileName())) {
            return METADATA_RULE;
        }
        return null;
    }
}

