/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal;

import com.google.common.base.Preconditions;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.MavenPathParser;
import org.sonatype.nexus.repository.maven.internal.Constants;

@Singleton
@Named(value="maven2")
public class Maven2MavenPathParser
extends ComponentSupport
implements MavenPathParser {
    private static final String TAR_EXT_PREFIX = ".tar";
    private static final String CPIO_EXT_PREFIX = ".cpio";
    private static final String NK_OS_EXT = ".nk.os";

    @Override
    @Nonnull
    public MavenPath parsePath(String path) {
        return this.parsePath(path, true);
    }

    @Override
    @Nonnull
    public MavenPath parsePath(String path, boolean caseSensitive) {
        Preconditions.checkNotNull((Object)path);
        String pathWithoutLeadingSlash = path;
        if (path.startsWith("/")) {
            pathWithoutLeadingSlash = path.substring(1);
        }
        MavenPath.Coordinates coordinates = this.maven2LayoutedPathToCoordinates(pathWithoutLeadingSlash, caseSensitive);
        return new MavenPath(pathWithoutLeadingSlash, coordinates);
    }

    @Override
    public boolean isRepositoryMetadata(MavenPath path) {
        return path.main().getFileName().equals("maven-metadata.xml");
    }

    @Override
    public boolean isRepositoryIndex(MavenPath path) {
        return path.getPath().equals(".index/nexus-maven-repository-index.gz") || path.getPath().equals(".index/nexus-maven-repository-index.properties");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private MavenPath.Coordinates maven2LayoutedPathToCoordinates(String pathString, boolean caseSensitive) {
        String str = pathString;
        try {
            int nExtPos;
            String fileName;
            int vEndPos = str.lastIndexOf(47);
            if (vEndPos == -1) {
                return null;
            }
            int aEndPos = str.lastIndexOf(47, vEndPos - 1);
            if (aEndPos == -1) {
                return null;
            }
            int gEndPos = str.lastIndexOf(47, aEndPos - 1);
            if (gEndPos == -1) {
                return null;
            }
            String groupId = str.substring(0, gEndPos).replace('/', '.');
            String artifactId = str.substring(gEndPos + 1, aEndPos);
            String baseVersion = str.substring(aEndPos + 1, vEndPos);
            boolean snapshot = baseVersion.endsWith("SNAPSHOT");
            str = fileName = str.substring(vEndPos + 1);
            StringBuilder extSuffix = new StringBuilder();
            Enum signatureType = null;
            Enum[] enumArray = MavenPath.HashType.values();
            int n = enumArray.length;
            int n2 = 0;
            while (n2 < n) {
                MavenPath.HashType hashType = enumArray[n2];
                if (str.endsWith("." + hashType.getExt())) {
                    extSuffix.insert(0, "." + hashType.getExt());
                    str = str.substring(0, str.length() - (hashType.getExt().length() + 1));
                    break;
                }
                ++n2;
            }
            enumArray = MavenPath.SignatureType.values();
            n = enumArray.length;
            n2 = 0;
            while (n2 < n) {
                Enum sType = enumArray[n2];
                if (str.endsWith("." + ((MavenPath.SignatureType)sType).getExt())) {
                    extSuffix.insert(0, "." + ((MavenPath.SignatureType)sType).getExt());
                    str = str.substring(0, str.length() - (((MavenPath.SignatureType)sType).getExt().length() + 1));
                    signatureType = sType;
                }
                ++n2;
            }
            if (str.endsWith("maven-metadata.xml")) {
                return null;
            }
            String version = baseVersion;
            Long timestamp = null;
            Integer buildNumber = null;
            String tail = null;
            if (snapshot) {
                int vSnapshotStart = artifactId.length() + 1 + baseVersion.length() - "SNAPSHOT".length();
                version = str.substring(vSnapshotStart, vSnapshotStart + "SNAPSHOT".length());
                if ("SNAPSHOT".equals(version)) {
                    int vTimestampStart = vSnapshotStart + version.length() + 1;
                    version = baseVersion;
                    tail = str.substring(artifactId.length() + baseVersion.length() + 1);
                    if (str.length() > vTimestampStart + "YYYYMMdd.HHmmss".length()) {
                        try {
                            Constants.METADATA_DOTTED_TIMESTAMP.parseDateTime(str.substring(vTimestampStart, vTimestampStart + "YYYYMMdd.HHmmss".length())).getMillis();
                            version = str.substring(vTimestampStart, vTimestampStart + "SNAPSHOT".length());
                            vSnapshotStart = vTimestampStart;
                            tail = null;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    }
                }
                if (tail == null) {
                    StringBuilder snapshotTimestampedVersion = new StringBuilder(version);
                    snapshotTimestampedVersion.append(str.substring(vSnapshotStart + version.length(), vSnapshotStart + version.length() + "SNAPSHOT".length() - 1));
                    try {
                        timestamp = Constants.METADATA_DOTTED_TIMESTAMP.parseDateTime(snapshotTimestampedVersion.toString()).getMillis();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.log.trace("metadata dotted timestamp failed parsing to millis {}", (Object)snapshotTimestampedVersion.toString());
                    }
                    snapshotTimestampedVersion.append('-');
                    int buildNumberPos = vSnapshotStart + snapshotTimestampedVersion.length();
                    StringBuilder bnr = new StringBuilder();
                    while (str.charAt(buildNumberPos) >= '0' && str.charAt(buildNumberPos) <= '9') {
                        snapshotTimestampedVersion.append(str.charAt(buildNumberPos));
                        bnr.append(str.charAt(buildNumberPos));
                        ++buildNumberPos;
                    }
                    try {
                        buildNumber = Integer.parseInt(bnr.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.log.trace("build number failed parsing {}", (Object)bnr);
                    }
                    tail = str.substring(vSnapshotStart + snapshotTimestampedVersion.length());
                    version = String.valueOf(baseVersion.substring(0, baseVersion.length() - "SNAPSHOT".length())) + snapshotTimestampedVersion;
                }
            } else {
                String fileNameStr = fileName;
                String artifactStr = String.valueOf(artifactId) + "-" + baseVersion;
                if (!caseSensitive) {
                    fileNameStr = fileNameStr.toLowerCase(Locale.ROOT);
                    artifactStr = artifactStr.toLowerCase(Locale.ROOT);
                }
                if (!fileNameStr.startsWith(artifactStr) || "-.".indexOf(fileNameStr.charAt(artifactStr.length())) == -1) {
                    return null;
                }
                int nTailPos = artifactId.length() + baseVersion.length() + 1;
                tail = str.substring(nTailPos);
            }
            if ((nExtPos = this.getExceptionPos(tail)) == -1) {
                return null;
            }
            String ext = tail.substring(nExtPos + 1);
            String classifier = tail.charAt(0) == '-' ? tail.substring(1, nExtPos) : null;
            return new MavenPath.Coordinates(snapshot, groupId, artifactId, version, timestamp, buildNumber, baseVersion, classifier, String.valueOf(ext) + extSuffix, (MavenPath.SignatureType)signatureType);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return null;
        }
    }

    private int getExceptionPos(String tail) {
        int nExtPos = tail.lastIndexOf(46);
        if (nExtPos == -1) {
            return -1;
        }
        String tailWithoutExt = tail.substring(0, nExtPos);
        if (tailWithoutExt.endsWith(TAR_EXT_PREFIX)) {
            nExtPos -= TAR_EXT_PREFIX.length();
        } else if (tailWithoutExt.endsWith(CPIO_EXT_PREFIX)) {
            nExtPos -= CPIO_EXT_PREFIX.length();
        } else if (tail.endsWith(NK_OS_EXT)) {
            nExtPos = tail.length() - NK_OS_EXT.length();
        }
        return nExtPos;
    }
}

