/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.capability.CapabilityReference;
import org.sonatype.nexus.capability.CapabilityReferenceFilterBuilder;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.utils.httpclient.UserAgentGenerator;

@Named
public class MavenProxyRequestHeaderSupport {
    private static final String ANALYTICS_CAPABILITY = "analytics-configuration";
    private final CapabilityRegistry capabilityRegistry;
    private final UserAgentGenerator userAgentGenerator;

    @Inject
    public MavenProxyRequestHeaderSupport(CapabilityRegistry capabilityRegistry, UserAgentGenerator userAgentGenerator) {
        this.capabilityRegistry = (CapabilityRegistry)Preconditions.checkNotNull((Object)capabilityRegistry);
        this.userAgentGenerator = (UserAgentGenerator)Preconditions.checkNotNull((Object)userAgentGenerator);
    }

    public String getUserAgentForAnalytics() {
        CapabilityReference capabilityReference = this.getCapabilityReference();
        return this.userAgentGenerator.buildUserAgentForAnalytics(capabilityReference);
    }

    @Nullable
    public CapabilityReference getCapabilityReference() {
        CapabilityType capabilityType = CapabilityType.capabilityType((String)ANALYTICS_CAPABILITY);
        Collection refs = this.capabilityRegistry.get((Predicate)CapabilityReferenceFilterBuilder.capabilities().withType(capabilityType).includeNotExposed());
        CapabilityReference capabilityReference = null;
        if (!refs.isEmpty()) {
            capabilityReference = (CapabilityReference)refs.iterator().next();
        }
        return capabilityReference;
    }
}

