/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonatype.nexus.common.hash.HashAlgorithm;

@Immutable
public class MavenPath {
    private final String path;
    private final String fileName;
    private final HashType hashType;
    private final Coordinates coordinates;

    public MavenPath(String path, Coordinates coordinates) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkArgument((!path.startsWith("/") ? 1 : 0) != 0, (Object)"Path must not start with '/'");
        this.path = path;
        this.fileName = this.path.substring(path.lastIndexOf(47) + 1);
        HashType ht = null;
        HashType[] hashTypeArray = HashType.values();
        int n = hashTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            HashType v = hashTypeArray[n2];
            if (this.fileName.endsWith("." + v.getExt())) {
                ht = v;
                break;
            }
            ++n2;
        }
        this.hashType = ht;
        this.coordinates = coordinates;
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    @Nonnull
    public String getFileName() {
        return this.fileName;
    }

    @Nullable
    public HashType getHashType() {
        return this.hashType;
    }

    @Nullable
    public Coordinates getCoordinates() {
        return this.coordinates;
    }

    public boolean isSubordinate() {
        return this.isHash() || this.isSignature();
    }

    public boolean isHash() {
        return this.hashType != null;
    }

    public boolean isSignature() {
        return this.coordinates != null && this.coordinates.getSignatureType() != null;
    }

    public boolean isPom() {
        return this.coordinates != null && "pom".equals(this.coordinates.getExtension());
    }

    @Nonnull
    public MavenPath main() {
        MavenPath mavenPath = this;
        while (mavenPath.isSubordinate()) {
            mavenPath = mavenPath.subordinateOf();
        }
        return mavenPath;
    }

    @Nonnull
    public MavenPath subordinateOf() {
        if (this.hashType != null) {
            int hashSuffixLen = this.hashType.getExt().length() + 1;
            Coordinates mainCoordinates = null;
            if (this.coordinates != null) {
                mainCoordinates = new Coordinates(this.coordinates.isSnapshot(), this.coordinates.getGroupId(), this.coordinates.getArtifactId(), this.coordinates.getVersion(), this.coordinates.getTimestamp(), this.coordinates.getBuildNumber(), this.coordinates.getBaseVersion(), this.coordinates.getClassifier(), this.coordinates.getExtension().substring(0, this.coordinates.getExtension().length() - hashSuffixLen), this.coordinates.getSignatureType());
            }
            return new MavenPath(this.path.substring(0, this.path.length() - hashSuffixLen), mainCoordinates);
        }
        if (this.coordinates != null && this.coordinates.getSignatureType() != null) {
            int signatureSuffixLen = this.coordinates.getSignatureType().getExt().length() + 1;
            Coordinates mainCoordinates = new Coordinates(this.coordinates.isSnapshot(), this.coordinates.getGroupId(), this.coordinates.getArtifactId(), this.coordinates.getVersion(), this.coordinates.getTimestamp(), this.coordinates.getBuildNumber(), this.coordinates.getBaseVersion(), this.coordinates.getClassifier(), this.coordinates.getExtension().substring(0, this.coordinates.getExtension().length() - signatureSuffixLen), null);
            return new MavenPath(this.path.substring(0, this.path.length() - signatureSuffixLen), mainCoordinates);
        }
        return this;
    }

    @Nonnull
    public MavenPath hash(HashType hashType) {
        return this.hash(hashType.getExt());
    }

    @Nonnull
    public MavenPath hash(HashAlgorithm hashType) {
        return this.hash(hashType.name());
    }

    @Nonnull
    private MavenPath hash(String hashExtension) {
        Preconditions.checkNotNull((Object)hashExtension);
        Preconditions.checkArgument((this.hashType == null ? 1 : 0) != 0, (String)"This path is already a hash: %s", (Object)this);
        Coordinates hashCoordinates = null;
        if (this.coordinates != null) {
            hashCoordinates = new Coordinates(this.coordinates.isSnapshot(), this.coordinates.getGroupId(), this.coordinates.getArtifactId(), this.coordinates.getVersion(), this.coordinates.getTimestamp(), this.coordinates.getBuildNumber(), this.coordinates.getBaseVersion(), this.coordinates.getClassifier(), String.valueOf(this.coordinates.getExtension()) + "." + hashExtension, this.coordinates.getSignatureType());
        }
        return new MavenPath(String.valueOf(this.path) + "." + hashExtension, hashCoordinates);
    }

    @Nonnull
    public MavenPath signature(SignatureType signatureType) {
        Preconditions.checkNotNull((Object)((Object)signatureType));
        Preconditions.checkArgument((this.hashType == null ? 1 : 0) != 0, (String)"This path is already a hash: %s", (Object)this);
        Preconditions.checkArgument((this.coordinates != null ? 1 : 0) != 0, (String)"Only artifact paths may have signatures: %s", (Object)this);
        Preconditions.checkArgument((this.coordinates.getSignatureType() == null ? 1 : 0) != 0, (String)"This path is already a signature: %s", (Object)this);
        Coordinates signatureCoordinates = new Coordinates(this.coordinates.isSnapshot(), this.coordinates.getGroupId(), this.coordinates.getArtifactId(), this.coordinates.getVersion(), this.coordinates.getTimestamp(), this.coordinates.getBuildNumber(), this.coordinates.getBaseVersion(), this.coordinates.getClassifier(), String.valueOf(this.coordinates.getExtension()) + "." + signatureType.getExt(), signatureType);
        return new MavenPath(String.valueOf(this.path) + "." + signatureType.getExt(), signatureCoordinates);
    }

    @Nonnull
    public MavenPath locate(String extension, @Nullable String classifier) {
        Preconditions.checkNotNull((Object)extension);
        Preconditions.checkArgument((this.coordinates != null ? 1 : 0) != 0, (String)"Only artifact paths may locate: %s", (Object)this);
        MavenPath origin = this.main();
        Coordinates newCoordinates = new Coordinates(origin.coordinates.isSnapshot(), origin.coordinates.getGroupId(), origin.coordinates.getArtifactId(), origin.coordinates.getVersion(), origin.coordinates.getTimestamp(), origin.coordinates.getBuildNumber(), origin.coordinates.getBaseVersion(), classifier, extension, null);
        String newPath = origin.path.substring(0, origin.path.length() - origin.coordinates.extension.length() - 1);
        if (origin.coordinates.classifier != null) {
            newPath = newPath.substring(0, newPath.length() - origin.coordinates.classifier.length() - 1);
        }
        if (classifier != null) {
            newPath = String.valueOf(newPath) + "-" + classifier;
        }
        newPath = String.valueOf(newPath) + "." + extension;
        return new MavenPath(newPath, newCoordinates);
    }

    @Nonnull
    public MavenPath locatePom() {
        return this.locate("pom", null);
    }

    @Nonnull
    public MavenPath locateMainArtifact(String extension) {
        return this.locate(extension, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MavenPath)) {
            return false;
        }
        MavenPath that = (MavenPath)o;
        return this.path.equals(that.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "path='" + this.path + '\'' + ", hashType=" + (Object)((Object)this.hashType) + '}';
    }

    public static class Coordinates {
        private final boolean snapshot;
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final Long timestamp;
        private final Integer buildNumber;
        private final String baseVersion;
        private final String classifier;
        private final String extension;
        private final SignatureType signatureType;

        public Coordinates(boolean snapshot, String groupId, String artifactId, String version, @Nullable Long timestamp, @Nullable Integer buildNumber, String baseVersion, @Nullable String classifier, String extension, SignatureType signatureType) {
            this.snapshot = snapshot;
            this.groupId = (String)Preconditions.checkNotNull((Object)groupId);
            this.artifactId = (String)Preconditions.checkNotNull((Object)artifactId);
            this.version = (String)Preconditions.checkNotNull((Object)version);
            this.timestamp = snapshot ? timestamp : null;
            this.buildNumber = snapshot ? buildNumber : null;
            this.baseVersion = (String)Preconditions.checkNotNull((Object)baseVersion);
            this.classifier = classifier;
            this.extension = (String)Preconditions.checkNotNull((Object)extension);
            this.signatureType = signatureType;
        }

        public boolean isSnapshot() {
            return this.snapshot;
        }

        @Nonnull
        public String getGroupId() {
            return this.groupId;
        }

        @Nonnull
        public String getArtifactId() {
            return this.artifactId;
        }

        @Nonnull
        public String getVersion() {
            return this.version;
        }

        @Nullable
        public Long getTimestamp() {
            return this.timestamp;
        }

        @Nullable
        public Integer getBuildNumber() {
            return this.buildNumber;
        }

        @Nonnull
        public String getBaseVersion() {
            return this.baseVersion;
        }

        @Nullable
        public String getClassifier() {
            return this.classifier;
        }

        @Nonnull
        public String getExtension() {
            return this.extension;
        }

        @Nullable
        public SignatureType getSignatureType() {
            return this.signatureType;
        }
    }

    public static enum HashType {
        SHA1("sha1", HashAlgorithm.SHA1),
        SHA256("sha256", HashAlgorithm.SHA256),
        SHA512("sha512", HashAlgorithm.SHA512),
        MD5("md5", HashAlgorithm.MD5);

        public static final List<HashAlgorithm> ALGORITHMS;
        private final String ext;
        private final HashAlgorithm hashAlgorithm;

        static {
            ALGORITHMS = ImmutableList.of((Object)SHA1.getHashAlgorithm(), (Object)MD5.getHashAlgorithm(), (Object)SHA256.getHashAlgorithm(), (Object)SHA512.getHashAlgorithm());
        }

        private HashType(String ext, HashAlgorithm hashAlgorithm) {
            this.ext = ext;
            this.hashAlgorithm = hashAlgorithm;
        }

        public String getExt() {
            return this.ext;
        }

        public HashAlgorithm getHashAlgorithm() {
            return this.hashAlgorithm;
        }
    }

    public static enum SignatureType {
        GPG("asc");

        private final String ext;

        private SignatureType(String ext) {
            this.ext = ext;
        }

        public String getExt() {
            return this.ext;
        }
    }
}

