/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven;

import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.maven.ContentDisposition;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Response;

@Named
@Singleton
public class ContentDispositionHandler
implements Handler {
    public static final String CONTENT_DISPOSITION_HEADER = "Content-Disposition";
    public static final String CONTENT_DISPOSITION_CONFIG_KEY = "contentDisposition";

    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        Response response = context.proceed();
        String action = context.getRequest().getAction();
        if ("GET".equals(action)) {
            String contentDisposition = (String)context.getRepository().getConfiguration().attributes("maven").get(CONTENT_DISPOSITION_CONFIG_KEY, String.class, (Object)ContentDisposition.INLINE.name());
            response.getHeaders().replace(CONTENT_DISPOSITION_HEADER, new String[]{ContentDisposition.valueOf(contentDisposition).getValue()});
        }
        return response;
    }
}

