/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.content.maven.upgrade;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.maven.ContentDisposition;
import org.sonatype.nexus.repository.maven.internal.MavenDefaultRepositoriesContributor;
import org.sonatype.nexus.upgrade.datastore.DatabaseMigrationStep;

@Named
@Singleton
public class MavenDefaultReposUpgrade_1_17
implements DatabaseMigrationStep {
    private static final String FIND_ATTRIBUTES_BY_NAME = "SELECT attributes from repository WHERE name = ?;";
    private static final String UPDATE_ATTRIBUTES_BY_NAME = "UPDATE repository SET attributes = ? WHERE name = ?;";
    private final MavenDefaultRepositoriesContributor defaultRepositoriesContributor;
    private final ObjectMapper mapper;

    @Inject
    public MavenDefaultReposUpgrade_1_17(MavenDefaultRepositoriesContributor defaultRepositoriesContributor) {
        this.defaultRepositoriesContributor = defaultRepositoriesContributor;
        this.mapper = new ObjectMapper();
    }

    public Optional<String> version() {
        return Optional.of("1.17");
    }

    public void migrate(Connection connection) throws Exception {
        this.defaultRepositoriesContributor.getRepositoryConfigurations().stream().filter(configuration -> !"maven2-group".equals(configuration.getRecipeName())).map(Configuration::getRepositoryName).forEach(name -> this.update(connection, (String)name));
    }

    private void update(Connection connection, String repositoryName) {
        try {
            ObjectNode attributes = this.getCurrentAttributes(connection, repositoryName);
            ObjectNode mavenAttributes = (ObjectNode)attributes.get("maven");
            if (mavenAttributes != null) {
                JsonNode current = mavenAttributes.get("contentDisposition");
                if (current == null) {
                    mavenAttributes.put("contentDisposition", ContentDisposition.INLINE.name());
                    attributes.set("maven", (JsonNode)mavenAttributes);
                }
            } else {
                ObjectNode mavenNode = this.mapper.createObjectNode();
                mavenNode.put("contentDisposition", ContentDisposition.INLINE.name());
                attributes.set("maven", (JsonNode)mavenNode);
            }
            this.updateAttributes(connection, repositoryName, this.mapper.writeValueAsBytes((Object)attributes));
        }
        catch (JsonProcessingException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private ObjectNode getCurrentAttributes(Connection connection, String repositoryName) throws SQLException, JsonProcessingException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (PreparedStatement ps = connection.prepareStatement(FIND_ATTRIBUTES_BY_NAME);){
            ps.setString(1, repositoryName);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                String attributes = rs.getString(1);
                return (ObjectNode)this.mapper.readTree(attributes);
            }
            return this.mapper.createObjectNode();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void updateAttributes(Connection connection, String repositoryName, byte[] attributes) throws SQLException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (PreparedStatement ps = connection.prepareStatement(UPDATE_ATTRIBUTES_BY_NAME);){
            if (this.isH2(connection)) {
                ps.setBytes(1, attributes);
            } else {
                ps.setString(1, new String(attributes, StandardCharsets.UTF_8));
            }
            ps.setString(2, repositoryName);
            ps.executeUpdate();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

