/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.content.maven.store;

import com.google.inject.assistedinject.Assisted;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.content.maven.store.GAV;
import org.sonatype.nexus.content.maven.store.Maven2ComponentDAO;
import org.sonatype.nexus.content.maven.store.Maven2ComponentData;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.repository.content.store.ComponentStore;
import org.sonatype.nexus.transaction.Transactional;

public class Maven2ComponentStore
extends ComponentStore<Maven2ComponentDAO> {
    @Inject
    public Maven2ComponentStore(DataSessionSupplier sessionSupplier, @Named(value="${nexus.datastore.clustered.enabled:-false}") @Named(value="${nexus.datastore.clustered.enabled:-false}") boolean clustered, @Assisted String storeName) {
        super(sessionSupplier, clustered, storeName, Maven2ComponentDAO.class);
    }

    @Transactional
    public void updateBaseVersion(Maven2ComponentData component) {
        ((Maven2ComponentDAO)this.dao()).updateBaseVersion(component);
    }

    @Transactional
    public Set<GAV> findGavsWithSnaphots(int repositoryId, int minimumRetained) {
        return ((Maven2ComponentDAO)this.dao()).findGavsWithSnaphots(repositoryId, minimumRetained);
    }

    @Transactional
    public List<Maven2ComponentData> findComponentsForGav(int repositoryId, String name, String group, String baseVersion, String releaseVersion) {
        return ((Maven2ComponentDAO)this.dao()).findComponentsForGav(repositoryId, name, group, baseVersion, releaseVersion);
    }

    @Transactional
    public Set<String> getBaseVersions(int repositoryId, String namespace, String name) {
        return ((Maven2ComponentDAO)this.dao()).getBaseVersions(repositoryId, namespace, name);
    }

    @Transactional
    public int[] selectSnapshotsAfterRelease(int repositoryId, int gracePeriod) {
        return ((Maven2ComponentDAO)this.dao()).selectSnapshotsAfterRelease(gracePeriod, repositoryId);
    }

    @Transactional
    public Collection<Integer> selectUnusedSnapshots(int repositoryId, LocalDate olderThan, long limit) {
        return ((Maven2ComponentDAO)this.dao()).selectUnusedSnapshots(repositoryId, olderThan, limit);
    }
}

