/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.content.maven.internal.snapshot;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.joda.time.DateTime;
import org.sonatype.nexus.content.maven.MavenContentFacet;
import org.sonatype.nexus.content.maven.store.GAV;
import org.sonatype.nexus.content.maven.store.Maven2ComponentData;
import org.sonatype.nexus.logging.task.ProgressLogIntervalHelper;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.store.ComponentData;
import org.sonatype.nexus.repository.content.store.InternalIds;
import org.sonatype.nexus.repository.maven.RemoveSnapshotsFacet;
import org.sonatype.nexus.repository.maven.VersionPolicy;
import org.sonatype.nexus.repository.maven.internal.group.MavenGroupFacet;
import org.sonatype.nexus.repository.maven.tasks.RemoveSnapshotsConfig;

@Named
public class RemoveSnapshotsFacetImpl
extends FacetSupport
implements RemoveSnapshotsFacet {
    private final Type groupType;

    @Inject
    public RemoveSnapshotsFacetImpl(@Named(value="group") @Named(value="group") Type groupType) {
        this.groupType = (Type)Preconditions.checkNotNull((Object)groupType);
    }

    @Override
    public void removeSnapshots(RemoveSnapshotsConfig config) {
        Repository repository = this.getRepository();
        String repositoryName = repository.getName();
        this.log.info("Beginning snapshot removal on repository '{}' with configuration: {}", (Object)repositoryName, (Object)config);
        if (this.groupType.equals((Object)repository.getType())) {
            this.processGroup((MavenGroupFacet)repository.facet(MavenGroupFacet.class), config);
        } else {
            this.processRepository(repository, config);
        }
        this.log.info("Completed snapshot removal on repository '{}'", (Object)repositoryName);
    }

    private void processGroup(MavenGroupFacet groupFacet, RemoveSnapshotsConfig config) {
        groupFacet.members().stream().filter(member -> this.isSnapshotRepo((Repository)member) || this.groupType.equals((Object)member.getType())).forEach(member -> ((RemoveSnapshotsFacet)member.facet(RemoveSnapshotsFacet.class)).removeSnapshots(config));
    }

    private boolean isSnapshotRepo(Repository member) {
        return ((MavenContentFacet)member.facet(MavenContentFacet.class)).getVersionPolicy() != VersionPolicy.RELEASE;
    }

    @VisibleForTesting
    void processRepository(Repository repository, RemoveSnapshotsConfig config) {
        this.log.info("Begin processing snapshots in repository '{}'", (Object)repository.getName());
        this.deleteRedundantSnapshots(repository, config);
        this.deleteSnapshotsForReleasedComponents(repository, config);
        this.log.info("Finished processing snapshots with more than {} versions created before {}", (Object)config.getMinimumRetained(), (Object)DateTime.now().minusDays(Math.max(config.getSnapshotRetentionDays(), 0)));
    }

    @VisibleForTesting
    Set<GAV> findSnapshotCandidates(Repository repository, int minimumRetained) {
        this.log.info(TaskLoggingMarkers.PROGRESS, "Searching for GAVs with snapshots that qualify for deletion on repository '{}'", (Object)repository.getName());
        MavenContentFacet facet = (MavenContentFacet)repository.facet(MavenContentFacet.class);
        return facet.findGavsWithSnaphots(minimumRetained);
    }

    @VisibleForTesting
    List<Maven2ComponentData> findComponentsForGav(Repository repository, GAV gav) {
        MavenContentFacet facet = (MavenContentFacet)repository.facet(MavenContentFacet.class);
        String releaseVersion = gav.baseVersion.replace("-SNAPSHOT", "");
        return facet.findComponentsForGav(gav.name, gav.group, gav.baseVersion, releaseVersion);
    }

    @VisibleForTesting
    Set<Maven2ComponentData> getSnapshotsToDelete(RemoveSnapshotsConfig config, List<Maven2ComponentData> components) {
        HashSet<Maven2ComponentData> snapshotsToDelete = new HashSet<Maven2ComponentData>();
        OffsetDateTime retentionTimeBorder = OffsetDateTime.now().minusDays(Math.max(config.getSnapshotRetentionDays(), 0));
        int keptSnapshotsCount = 0;
        if (config.getMinimumRetained() >= 0) {
            for (Maven2ComponentData component : components) {
                if (retentionTimeBorder.isAfter(this.calculateLastUpdated(component)) && keptSnapshotsCount >= config.getMinimumRetained()) {
                    snapshotsToDelete.add(component);
                    continue;
                }
                ++keptSnapshotsCount;
            }
        }
        return snapshotsToDelete;
    }

    @VisibleForTesting
    OffsetDateTime calculateLastUpdated(ComponentData component) {
        OffsetDateTime lastUpdated = component.lastUpdated();
        if (component.getAssets() != null) {
            lastUpdated = component.getAssets().stream().map(Asset::blob).filter(Optional::isPresent).map(assetBlob -> ((AssetBlob)assetBlob.get()).blobCreated()).max(OffsetDateTime::compareTo).orElse(lastUpdated);
        }
        return lastUpdated;
    }

    @VisibleForTesting
    void deleteRedundantSnapshots(Repository repository, RemoveSnapshotsConfig config) {
        Set<GAV> snapshotCandidates = this.findSnapshotCandidates(repository, Math.max(config.getMinimumRetained(), 0));
        this.log.debug("Found {} snapshot GAVs to analyze", (Object)snapshotCandidates.size());
        HashSet<GAV> gavsWithDeletions = new HashSet<GAV>();
        Throwable throwable = null;
        Object var6_7 = null;
        try (ProgressLogIntervalHelper intervalLogger = new ProgressLogIntervalHelper(this.log, 60);){
            HashSet<Maven2ComponentData> redundantSnapshots = new HashSet<Maven2ComponentData>();
            for (GAV snapshotCandidate : snapshotCandidates) {
                Set<Maven2ComponentData> snapshotsToDelete;
                this.log.debug("Processing GAV = {}", (Object)snapshotCandidate);
                List<Maven2ComponentData> components = this.findComponentsForGav(repository, snapshotCandidate);
                if (components.isEmpty() || (snapshotsToDelete = this.getSnapshotsToDelete(config, components)).isEmpty()) continue;
                redundantSnapshots.addAll(snapshotsToDelete);
                this.log.debug("Found {} snapshots to remove for GAV = {}", (Object)redundantSnapshots.size(), (Object)snapshotCandidate);
                gavsWithDeletions.add(snapshotCandidate);
            }
            if (!redundantSnapshots.isEmpty()) {
                MavenContentFacet facet = (MavenContentFacet)repository.facet(MavenContentFacet.class);
                facet.deleteComponents(redundantSnapshots.stream().mapToInt(InternalIds::internalComponentId).toArray());
            }
            intervalLogger.flush();
            this.log.info("Elapsed time: {}, deleted {} components from {} distinct GAVs", new Object[]{intervalLogger.getElapsed(), redundantSnapshots.size(), gavsWithDeletions.size()});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @VisibleForTesting
    void deleteSnapshotsForReleasedComponents(Repository repository, RemoveSnapshotsConfig config) {
        if (config.getRemoveIfReleased()) {
            MavenContentFacet facet = (MavenContentFacet)repository.facet(MavenContentFacet.class);
            int[] snapshotsAfterReleaseToDelete = facet.selectSnapshotsAfterRelease(Math.max(config.getGracePeriod(), 0));
            facet.deleteComponents(snapshotsAfterReleaseToDelete);
            this.log.info("Deleted {} snapshots for released components", (Object)snapshotsAfterReleaseToDelete.length);
        }
    }
}

