/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.content.maven.internal.search.table;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.search.sql.SearchCustomFieldContributor;
import org.sonatype.nexus.repository.search.sql.SearchRecord;

@Singleton
@Named(value="maven2")
public class MavenSearchCustomFieldContributor
implements SearchCustomFieldContributor {
    public void populateSearchCustomFields(SearchRecord searchTableData, Asset asset) {
        Object formatAttributes = asset.attributes().get("maven2");
        Map attributes = formatAttributes instanceof Map ? (Map)formatAttributes : Collections.emptyMap();
        Optional.ofNullable((String)attributes.get("baseVersion")).map(MavenSearchCustomFieldContributor::preventTokenization).ifPresent(arg_0 -> ((SearchRecord)searchTableData).addFormatFieldValue1(arg_0));
        Optional.ofNullable((String)attributes.get("extension")).ifPresent(arg_0 -> ((SearchRecord)searchTableData).addFormatFieldValue2(arg_0));
        Optional.ofNullable((String)attributes.get("classifier")).ifPresent(arg_0 -> ((SearchRecord)searchTableData).addFormatFieldValue3(arg_0));
        this.buildGavec(searchTableData, attributes);
    }

    private void buildGavec(SearchRecord searchTableData, Map<String, String> attributes) {
        searchTableData.addFormatFieldValue4(this.getMavenAttributes(attributes).filter(Objects::nonNull).map(MavenSearchCustomFieldContributor::preventTokenization).collect(Collectors.joining(" ")));
    }

    private Stream<String> getMavenAttributes(Map<String, String> attributes) {
        return Stream.of(attributes.get("groupId"), attributes.get("artifactId"), attributes.get("baseVersion"), attributes.get("extension"), attributes.get("classifier"));
    }

    static String preventTokenization(String searchTerm) {
        return StringUtils.isBlank((CharSequence)searchTerm) ? "" : "/" + searchTerm;
    }
}

