/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.content.maven.internal.search.table;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.content.utils.SearchComponentPathFilter;

@Named(value="maven2")
@Singleton
public class MavenSearchComponentPathFilter
implements SearchComponentPathFilter {
    public boolean shouldFilterPathExtension(String path) {
        return MavenType.getMavenTypes().stream().noneMatch(path::endsWith);
    }

    static enum MavenType {
        POM(".pom"),
        WAR(".war"),
        JAR(".jar"),
        EAR(".ear"),
        AAR(".aar"),
        ZIP(".zip"),
        TARGZ(".tar.gz");

        private final String mavenType;

        private MavenType(String mavenType) {
            this.mavenType = mavenType;
        }

        private String getMavenType() {
            return this.mavenType;
        }

        static List<String> getMavenTypes() {
            return Arrays.stream(MavenType.values()).map(MavenType::getMavenType).collect(Collectors.toList());
        }
    }
}

