/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.content.maven.internal.search.table;

import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.repository.search.query.SearchFilter;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryContributionSupport;
import org.sonatype.nexus.repository.search.sql.query.syntax.ExactTerm;
import org.sonatype.nexus.repository.search.sql.query.syntax.Expression;
import org.sonatype.nexus.repository.search.sql.query.syntax.StringTerm;

@Named(value="attributes.maven2.baseVersion")
@Singleton
public class MavenBaseVersionSqlSearchQueryContribution
extends SqlSearchQueryContributionSupport {
    protected static final String BASE_VERSION = "attributes.maven2.baseVersion";
    public static final String NAME = "attributes.maven2.baseVersion";

    public Optional<Expression> createPredicate(SearchFilter searchFilter) {
        String value = searchFilter.getValue();
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return super.createPredicate(new SearchFilter(searchFilter.getProperty(), value.trim()));
        }
        return super.createPredicate(searchFilter);
    }

    protected StringTerm createMatchTerm(boolean exact, String match) {
        return new ExactTerm("/" + match);
    }
}

