/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.content.maven.internal.recipe;

import com.google.common.base.Preconditions;
import java.time.LocalDate;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.content.maven.MavenContentFacet;
import org.sonatype.nexus.content.maven.internal.recipe.MavenContentFacetImpl;
import org.sonatype.nexus.content.maven.store.Maven2ComponentStore;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.maven.PurgeUnusedSnapshotsFacet;
import org.sonatype.nexus.repository.maven.internal.group.MavenGroupFacet;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.scheduling.TaskInterruptedException;

@Named
public class PurgeUnusedSnapshotsFacetImpl
extends FacetSupport
implements PurgeUnusedSnapshotsFacet {
    private final Type groupType;
    private final Type hostedType;
    private final int findUnusedLimit;

    @Inject
    public PurgeUnusedSnapshotsFacetImpl(@Named(value="group") @Named(value="group") Type groupType, @Named(value="hosted") @Named(value="hosted") Type hostedType, @Named(value="${nexus.tasks.purgeUnusedSnapshots.findUnusedLimit:-100}") @Named(value="${nexus.tasks.purgeUnusedSnapshots.findUnusedLimit:-100}") int findUnusedLimit) {
        this.groupType = (Type)Preconditions.checkNotNull((Object)groupType);
        this.hostedType = (Type)Preconditions.checkNotNull((Object)hostedType);
        this.findUnusedLimit = findUnusedLimit;
        Preconditions.checkArgument((findUnusedLimit >= 10 && findUnusedLimit <= 1000 ? 1 : 0) != 0, (Object)"nexus.tasks.purgeUnusedSnapshots.findUnusedLimit must be between 10 and 1000");
    }

    @Override
    @Guarded(by={"STARTED"})
    public void purgeUnusedSnapshots(int numberOfDays) {
        Preconditions.checkArgument((numberOfDays > 0 ? 1 : 0) != 0, (Object)"Number of days must be greater than zero");
        this.log.info("Purging unused snapshots {} days or older from repository {}", (Object)numberOfDays, (Object)this.getRepository().getName());
        if (this.groupType.equals((Object)this.getRepository().getType())) {
            this.processAsGroup((MavenGroupFacet)this.facet(MavenGroupFacet.class), numberOfDays);
        } else if (this.hostedType.equals((Object)this.getRepository().getType())) {
            this.purgeSnapshotsFromRepository(numberOfDays);
        } else {
            this.log.debug("Skipping repository {}, is not group or hosted", (Object)this.getRepository().getName());
        }
    }

    private void processAsGroup(MavenGroupFacet groupFacet, int numberOfDays) {
        groupFacet.leafMembers().stream().filter(member -> this.hostedType.equals((Object)member.getType())).forEach(member -> ((PurgeUnusedSnapshotsFacet)member.facet(PurgeUnusedSnapshotsFacet.class)).purgeUnusedSnapshots(numberOfDays));
    }

    private void purgeSnapshotsFromRepository(int numberOfDays) {
        LocalDate olderThan = LocalDate.now().minusDays(numberOfDays);
        this.deleteUnusedSnapshotComponents(olderThan);
    }

    private void deleteUnusedSnapshotComponents(LocalDate olderThan) {
        Repository repository = this.getRepository();
        MavenContentFacetImpl contentFacet = (MavenContentFacetImpl)repository.facet(MavenContentFacet.class);
        Maven2ComponentStore componentStore = (Maven2ComponentStore)contentFacet.stores().componentStore;
        long totalComponents = contentFacet.components().count();
        this.log.info("Found {} total components in repository {} to evaluate for unused snapshots", (Object)totalComponents, (Object)repository.getName());
        while (!this.isCanceled()) {
            int[] componentIds = componentStore.selectUnusedSnapshots(contentFacet.contentRepositoryId(), olderThan, this.findUnusedLimit).stream().mapToInt(id -> id).toArray();
            if (componentIds.length == 0) {
                return;
            }
            contentFacet.deleteComponents(componentIds);
        }
    }

    private boolean isCanceled() {
        try {
            CancelableHelper.checkCancellation();
            return false;
        }
        catch (TaskInterruptedException taskInterruptedException) {
            this.log.warn("Purge unused Maven snapshots job is canceled");
            return true;
        }
    }
}

