/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.content.maven.internal.recipe;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.content.AttributeChangeSet;
import org.sonatype.nexus.repository.content.AttributeOperation;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.replication.ReplicationFacetSupport;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.MavenPathParser;
import org.sonatype.nexus.repository.replication.ReplicationUtils;

@Named(value="maven2")
public class MavenReplicationFacet
extends ReplicationFacetSupport {
    private final Map<String, MavenPathParser> mavenPathParsers;
    private MavenPathParser mavenPathParser;

    @Inject
    public MavenReplicationFacet(Map<String, MavenPathParser> mavenPathParsers) {
        this.mavenPathParsers = (Map)Preconditions.checkNotNull(mavenPathParsers);
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.mavenPathParser = (MavenPathParser)Preconditions.checkNotNull((Object)this.mavenPathParsers.get(this.getRepository().getFormat().getValue()));
    }

    public void doReplicate(String path, Blob blob, Map<String, Object> assetAttributes, Map<String, Object> componentAttributes) {
        ContentFacet contentFacet = (ContentFacet)this.facet(ContentFacet.class);
        MavenPath mavenPath = this.mavenPathParser.parsePath(path);
        if (mavenPath.getCoordinates() != null) {
            this.replicateAssetWithComponent(contentFacet, path, mavenPath, blob, assetAttributes, componentAttributes);
        } else {
            this.replicateAssetWithoutComponent(contentFacet, path, blob, assetAttributes);
        }
    }

    private void replicateAssetWithComponent(ContentFacet contentFacet, String path, MavenPath mavenPath, Blob blob, Map<String, Object> assetAttributes, Map<String, Object> componentAttributes) {
        FluentComponent fluentComponent = contentFacet.components().name(mavenPath.getCoordinates().getArtifactId()).namespace(mavenPath.getCoordinates().getGroupId()).version(mavenPath.getCoordinates().getVersion()).getOrCreate();
        FluentAsset fluentAsset = contentFacet.assets().path(path).component((Component)fluentComponent).blob(blob, ReplicationUtils.getChecksumsFromProperties(assetAttributes)).save();
        AttributeChangeSet changeSet = new AttributeChangeSet();
        for (Map.Entry<String, Object> entry : assetAttributes.entrySet()) {
            changeSet.attributes(AttributeOperation.SET, entry.getKey(), entry.getValue());
        }
        fluentAsset.attributes(changeSet);
        for (Map.Entry<String, Object> entry : componentAttributes.entrySet()) {
            fluentComponent.attributes(AttributeOperation.SET, entry.getKey(), entry.getValue());
        }
    }

    private void replicateAssetWithoutComponent(ContentFacet contentFacet, String path, Blob blob, Map<String, Object> assetAttributes) {
        FluentAsset fluentAsset = contentFacet.assets().path(path).blob(blob, ReplicationUtils.getChecksumsFromProperties(assetAttributes)).save();
        AttributeChangeSet changeSet = new AttributeChangeSet();
        for (Map.Entry<String, Object> entry : assetAttributes.entrySet()) {
            changeSet.attributes(AttributeOperation.SET, entry.getKey(), entry.getValue());
        }
        fluentAsset.attributes(changeSet);
    }
}

