/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.content.maven.internal.recipe;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.apache.http.client.methods.HttpRequestBase;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.content.maven.MavenContentFacet;
import org.sonatype.nexus.repository.cache.CacheController;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.content.facet.ContentProxyFacetSupport;
import org.sonatype.nexus.repository.maven.LayoutPolicy;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.MavenProxyRequestHeaderSupport;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.validation.ConstraintViolationFactory;

@Named
public class MavenProxyFacet
extends ContentProxyFacetSupport {
    private static final String MAVEN_CENTRAL_HOST = "repo1.maven.org";
    final ConstraintViolationFactory constraintViolationFactory;
    private final MavenProxyRequestHeaderSupport mavenProxyRequestHeaderSupport;

    @Inject
    public MavenProxyFacet(ConstraintViolationFactory constraintViolationFactory, MavenProxyRequestHeaderSupport mavenProxyRequestHeaderSupport) {
        this.constraintViolationFactory = (ConstraintViolationFactory)Preconditions.checkNotNull((Object)constraintViolationFactory);
        this.mavenProxyRequestHeaderSupport = (MavenProxyRequestHeaderSupport)Preconditions.checkNotNull((Object)mavenProxyRequestHeaderSupport);
    }

    protected void doValidate(Configuration configuration) throws Exception {
        super.doValidate(configuration);
        this.validatePreemptiveAuth(configuration);
    }

    private void validatePreemptiveAuth(Configuration configuration) {
        String remoteUrl;
        boolean isPreemptive;
        NestedAttributesMap httpclient = configuration.attributes("httpclient");
        if (Objects.nonNull(httpclient.get("authentication")) && (isPreemptive = ((Boolean)configuration.attributes("httpclient").child("authentication").get("preemptive", Boolean.class, (Object)false)).booleanValue()) && !(remoteUrl = (String)configuration.attributes("proxy").get("remoteUrl", String.class, (Object)"")).startsWith("https://")) {
            ConstraintViolation violation = this.constraintViolationFactory.createViolation("attributes.httpclient.authentication.preemptive", "Pre-emptive authentication is allowed only when using HTTPS remote URL");
            throw new ConstraintViolationException((Set)ImmutableSet.of((Object)violation));
        }
    }

    protected Content getCachedContent(Context context) throws IOException {
        return this.content().get(this.mavenPath(context)).orElse(null);
    }

    @Nullable
    protected Content fetch(Context context, Content stale) throws IOException {
        MavenPath mavenPath;
        MavenContentFacet mavenFacet = this.content();
        if (!(stale != null || mavenFacet.layoutPolicy() != LayoutPolicy.STRICT || (mavenPath = this.mavenPath(context)).getCoordinates() != null || mavenFacet.getMavenPathParser().isRepositoryMetadata(mavenPath) || mavenFacet.getMavenPathParser().isRepositoryIndex(mavenPath) || mavenPath.getFileName().equals("archetype-catalog.xml"))) {
            return null;
        }
        return super.fetch(context, stale);
    }

    protected CacheController getCacheController(@Nonnull Context context) {
        if (this.content().getMavenPathParser().isRepositoryMetadata(this.mavenPath(context))) {
            return this.cacheControllerHolder.getMetadataCacheController();
        }
        return this.cacheControllerHolder.getContentCacheController();
    }

    protected Content store(Context context, Content payload) throws IOException {
        return this.content().put(this.mavenPath(context), (Payload)payload);
    }

    protected String getUrl(@Nonnull Context context) {
        return this.removePrefixingSlash(context.getRequest().getPath());
    }

    protected HttpRequestBase buildFetchHttpRequest(URI uri, Context context) {
        HttpRequestBase request = super.buildFetchHttpRequest(uri, context);
        if (MAVEN_CENTRAL_HOST.equals(uri.getHost())) {
            String augmentedUserAgent = this.mavenProxyRequestHeaderSupport.getUserAgentForAnalytics();
            request.setHeader("User-Agent", augmentedUserAgent);
        }
        return request;
    }

    @Nonnull
    private MavenPath mavenPath(@Nonnull Context context) {
        return (MavenPath)context.getAttributes().require(MavenPath.class);
    }

    private MavenContentFacet content() {
        return (MavenContentFacet)this.getRepository().facet(MavenContentFacet.class);
    }

    private String removePrefixingSlash(String url) {
        if (url != null && url.startsWith("/")) {
            return url.replaceFirst("/", "");
        }
        return url;
    }
}

