/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.content.maven.internal.recipe;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.common.hash.HashCode;
import com.google.common.io.ByteStreams;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.entity.DetachedEntityId;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.content.maven.MavenContentFacet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.cache.RepositoryCacheInvalidationService;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.event.asset.AssetCreatedEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetDeletedEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetPurgedEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetUploadedEvent;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.group.GroupFacetImpl;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.internal.group.ArchetypeCatalogMerger;
import org.sonatype.nexus.repository.maven.internal.group.MavenGroupFacet;
import org.sonatype.nexus.repository.maven.internal.group.RepositoryMetadataMerger;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.payloads.BlobPayload;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.thread.io.StreamCopier;
import org.sonatype.nexus.validation.ConstraintViolationFactory;

@Named
public class MavenContentGroupFacetImpl
extends GroupFacetImpl
implements MavenGroupFacet,
EventAware.Asynchronous {
    private static final String PATH_PREFIX = "/";
    private final RepositoryMetadataMerger repositoryMetadataMerger = new RepositoryMetadataMerger();
    private final ArchetypeCatalogMerger archetypeCatalogMerger = new ArchetypeCatalogMerger();

    @Inject
    public MavenContentGroupFacetImpl(RepositoryManager repositoryManager, ConstraintViolationFactory constraintViolationFactory, @Named(value="group") @Named(value="group") Type groupType, RepositoryCacheInvalidationService repositoryCacheInvalidationService) {
        super(repositoryManager, constraintViolationFactory, groupType, repositoryCacheInvalidationService);
    }

    @Override
    @Nullable
    public Content getCached(MavenPath mavenPath) throws IOException {
        this.checkMergeHandled(mavenPath);
        String path = StringUtils.prependIfMissing((String)mavenPath.getPath(), (CharSequence)PATH_PREFIX, (CharSequence[])new CharSequence[0]);
        this.log.trace("Checking cache for {}", (Object)path);
        Optional fluentAsset = ((ContentFacet)this.getRepository().facet(ContentFacet.class)).assets().path(path).find();
        if (!fluentAsset.isPresent()) {
            this.log.trace("cache miss for {}", (Object)path);
            return null;
        }
        FluentAsset asset = (FluentAsset)fluentAsset.get();
        Content content = asset.download();
        if (content.getSize() == 0L) {
            this.log.debug("Corrupted repository metadata: {}, source: {}", (Object)path, (Object)this.getRepository().getName());
            return null;
        }
        if (mavenPath.isHash()) {
            this.log.trace("Cache hit for hash {}", (Object)path);
            return new Content((Payload)content);
        }
        if (asset.isStale(this.cacheController)) {
            this.log.trace("Cache stale hit for {}", (Object)path);
            return null;
        }
        this.log.trace("Cache fresh hit for {}", (Object)path);
        return new Content((Payload)content);
    }

    @Override
    @Nullable
    public Content mergeAndCache(MavenPath mavenPath, Map<Repository, Response> responses) throws IOException {
        return this.merge(mavenPath, responses, this::createTempBlob, (T tempBlob, String contentType) -> {
            this.log.trace("Caching merged content");
            return this.cache(mavenPath, (TempBlob)tempBlob, contentType);
        });
    }

    @Override
    @Nullable
    public Content mergeWithoutCaching(MavenPath mavenPath, Map<Repository, Response> responses) throws IOException {
        return this.merge(mavenPath, responses, Function.identity(), (T in, String contentType) -> new Content((Payload)new BytesPayload(ByteStreams.toByteArray((InputStream)in), contentType)));
    }

    private Content cache(MavenPath mavenPath, TempBlob tempBlob, String contentType) throws IOException {
        try {
            Content content = new Content((Payload)((MavenContentFacet)this.getRepository().facet(MavenContentFacet.class)).put(mavenPath, (Payload)new BlobPayload(tempBlob.getBlob(), contentType)));
            this.maintainCacheInfo(content.getAttributes());
            this.mayAddETag(content.getAttributes(), tempBlob.getHashes());
            for (Map.Entry entry : tempBlob.getHashes().entrySet()) {
                ((MavenContentFacet)this.getRepository().facet(MavenContentFacet.class)).put(mavenPath.hash((HashAlgorithm)entry.getKey()), (Payload)new StringPayload(((HashCode)entry.getValue()).toString(), "text/plain"));
            }
            ((ContentFacet)this.getRepository().facet(ContentFacet.class)).assets().path(StringUtils.prependIfMissing((String)mavenPath.getPath(), (CharSequence)PATH_PREFIX, (CharSequence[])new CharSequence[0])).find().ifPresent(a -> {
                FluentAsset fluentAsset = a.markAsCached((Payload)content);
            });
            return content;
        }
        catch (Exception e) {
            this.log.warn("Problem caching merged content {} : {}", new Object[]{this.getRepository().getName(), mavenPath.getPath(), e});
            ((ContentFacet)this.getRepository().facet(ContentFacet.class)).assets().path(StringUtils.prependIfMissing((String)mavenPath.getPath(), (CharSequence)PATH_PREFIX, (CharSequence[])new CharSequence[0])).find().ifPresent(FluentAsset::markAsStale);
            Throwable throwable = null;
            Object var5_11 = null;
            try (InputStream in = tempBlob.get();){
                return new Content((Payload)new BytesPayload(ByteStreams.toByteArray((InputStream)in), contentType));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private <T> T merge(MavenGroupFacet.MetadataMerger merger, MavenPath mavenPath, LinkedHashMap<Repository, Content> contents, Function<InputStream, T> streamFunction) {
        return (T)new StreamCopier(outputStream -> merger.merge((OutputStream)outputStream, mavenPath, contents), streamFunction).read();
    }

    private TempBlob createTempBlob(InputStream inputStream) {
        List hashAlgorithms = Arrays.stream(MavenPath.HashType.values()).map(MavenPath.HashType::getHashAlgorithm).collect(Collectors.toList());
        return ((ContentFacet)this.getRepository().facet(ContentFacet.class)).blobs().ingest(inputStream, null, hashAlgorithms);
    }

    private void checkMergeHandled(MavenPath mavenPath) {
        Preconditions.checkArgument((((MavenContentFacet)this.getRepository().facet(MavenContentFacet.class)).getMavenPathParser().isRepositoryMetadata(mavenPath) || mavenPath.getFileName().equals("archetype-catalog.xml") ? 1 : 0) != 0, (String)"Not handled by Maven2GroupFacet merge: %s", (Object)mavenPath);
    }

    @Nullable
    private <T extends Closeable> Content merge(MavenPath mavenPath, Map<Repository, Response> responses, Function<InputStream, T> streamFunction, MavenGroupFacet.ContentFunction<T> contentFunction) throws IOException {
        this.checkMergeHandled(mavenPath);
        Preconditions.checkArgument((!mavenPath.isSubordinate() ? 1 : 0) != 0, (String)"Only main content handled, not hash or signature: %s", (Object)mavenPath);
        LinkedHashMap contents = Maps.newLinkedHashMap();
        for (Map.Entry<Repository, Response> entry : responses.entrySet()) {
            Response response;
            if (entry.getValue().getStatus().getCode() != 200 || !((response = entry.getValue()).getPayload() instanceof Content)) continue;
            contents.put(entry.getKey(), (Content)response.getPayload());
        }
        if (contents.isEmpty()) {
            this.log.trace("No 200 OK responses to merge");
            return null;
        }
        try (Closeable data = null;){
            String contentType = null;
            if (((MavenContentFacet)this.getRepository().facet(MavenContentFacet.class)).getMavenPathParser().isRepositoryMetadata(mavenPath)) {
                data = (Closeable)this.merge(this.repositoryMetadataMerger::merge, mavenPath, contents, streamFunction);
                contentType = "application/xml";
            } else if (mavenPath.getFileName().equals("archetype-catalog.xml")) {
                data = (Closeable)this.merge(this.archetypeCatalogMerger::merge, mavenPath, contents, streamFunction);
                contentType = "application/xml";
            }
            if (data == null) {
                this.log.trace("No content resulted out of merge");
                return null;
            }
            Content content = contentFunction.apply(data, contentType);
            return content;
        }
    }

    private void mayAddETag(AttributesMap attributesMap, Map<HashAlgorithm, HashCode> hashCodes) {
        if (attributesMap.contains("etag")) {
            return;
        }
        HashCode sha1HashCode = hashCodes.get(HashAlgorithm.SHA1);
        if (sha1HashCode != null) {
            attributesMap.set("etag", (Object)("{SHA1{" + sha1HashCode + "}}"));
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onAssetCreatedEvent(AssetCreatedEvent event) {
        this.handleAssetEvent((AssetEvent)event, false);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onAssetUploadedEvent(AssetUploadedEvent event) {
        this.handleAssetEvent((AssetEvent)event, false);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onAssetDeletedEvent(AssetDeletedEvent event) {
        this.handleAssetEvent((AssetEvent)event, true);
    }

    private void handleAssetEvent(AssetEvent event, boolean delete) {
        event.getRepository().ifPresent(repository -> this.maybeEvict((Repository)repository, event.getAsset(), delete));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onAssetPurgedEvent(AssetPurgedEvent event) {
        event.getRepository().ifPresent(repository -> {
            int[] nArray = event.getAssetIds();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int assetId = nArray[n2];
                ((ContentFacet)repository.facet(ContentFacet.class)).assets().find((EntityId)new DetachedEntityId(String.valueOf(assetId))).ifPresent(asset -> this.maybeEvict((Repository)repository, (Asset)asset, true));
                ++n2;
            }
        });
    }

    private void maybeEvict(Repository repository, Asset asset, boolean delete) {
        this.log.trace("Maybe evicting memberRepo:{} assetPath:{} shouldDelete:{}", new Object[]{repository.getName(), asset.path(), delete});
        if (!asset.component().isPresent() && this.member(repository)) {
            String path = asset.path();
            MavenPath mavenPath = ((MavenContentFacet)this.getRepository().facet(MavenContentFacet.class)).getMavenPathParser().parsePath(path);
            if (!mavenPath.isHash()) {
                if (delete) {
                    try {
                        ((MavenContentFacet)this.getRepository().facet(MavenContentFacet.class)).deleteWithHashes(mavenPath);
                        return;
                    }
                    catch (Exception e) {
                        this.log.warn("Problem deleting cached content {} : {}, will invalidate instead", new Object[]{this.getRepository().getName(), mavenPath.getPath(), e});
                    }
                }
                ((ContentFacet)this.getRepository().facet(ContentFacet.class)).assets().path(StringUtils.prependIfMissing((String)mavenPath.main().getPath(), (CharSequence)PATH_PREFIX, (CharSequence[])new CharSequence[0])).find().ifPresent(FluentAsset::markAsStale);
            }
        }
    }
}

