/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.content.maven.internal.recipe;

import java.util.HashMap;
import java.util.Optional;
import org.apache.maven.model.Model;
import org.sonatype.nexus.content.maven.store.Maven2ComponentData;
import org.sonatype.nexus.content.maven.store.Maven2ComponentStore;
import org.sonatype.nexus.repository.content.AttributeOperation;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.MavenPathParser;
import org.sonatype.nexus.repository.maven.internal.Attributes;

final class MavenAttributesHelper {
    private static final String JAR = "jar";

    private MavenAttributesHelper() {
    }

    static void setMavenAttributes(Maven2ComponentStore componentStore, FluentComponent component, MavenPath.Coordinates coordinates, Optional<Model> optionalModel, int repositoryId) {
        HashMap<String, String> mavenAttributes = new HashMap<String, String>();
        mavenAttributes.put("groupId", coordinates.getGroupId());
        mavenAttributes.put("artifactId", coordinates.getArtifactId());
        mavenAttributes.put("version", coordinates.getVersion());
        mavenAttributes.put("baseVersion", coordinates.getBaseVersion());
        mavenAttributes.put("extension", coordinates.getExtension());
        optionalModel.ifPresent(model -> {
            mavenAttributes.put("packaging", MavenAttributesHelper.getPackaging(model));
            Optional.ofNullable(model.getName()).ifPresent(name -> {
                String string = mavenAttributes.put("pom_name", (String)name);
            });
            Optional.ofNullable(model.getDescription()).ifPresent(desc -> {
                String string = mavenAttributes.put("pom_description", (String)desc);
            });
        });
        component.attributes(AttributeOperation.OVERLAY, "maven2", mavenAttributes);
        MavenAttributesHelper.fillInBaseVersionColumn(componentStore, (Component)component, repositoryId, coordinates.getBaseVersion());
    }

    static void setMavenAttributes(FluentAsset asset, MavenPath mavenPath) {
        HashMap<String, String> mavenAttributes = new HashMap<String, String>();
        MavenPath.Coordinates coordinates = mavenPath.getCoordinates();
        if (coordinates != null) {
            mavenAttributes.put("groupId", coordinates.getGroupId());
            mavenAttributes.put("artifactId", coordinates.getArtifactId());
            mavenAttributes.put("version", coordinates.getVersion());
            mavenAttributes.put("baseVersion", coordinates.getBaseVersion());
            Optional.ofNullable(coordinates.getClassifier()).ifPresent(value -> {
                String string = mavenAttributes.put("classifier", (String)value);
            });
            mavenAttributes.put("extension", coordinates.getExtension());
        }
        asset.attributes(AttributeOperation.OVERLAY, "maven2", mavenAttributes);
    }

    static String getPackaging(Model model) {
        String packaging = model.getPackaging();
        return packaging == null ? JAR : packaging;
    }

    static String assetKind(MavenPath mavenPath, MavenPathParser mavenPathParser) {
        if (mavenPath.getCoordinates() != null) {
            return MavenAttributesHelper.artifactRelatedAssetKind(mavenPath);
        }
        return MavenAttributesHelper.fileAssetKindFor(mavenPath, mavenPathParser);
    }

    private static String artifactRelatedAssetKind(MavenPath mavenPath) {
        return mavenPath.isSubordinate() ? Attributes.AssetKind.ARTIFACT_SUBORDINATE.name() : Attributes.AssetKind.ARTIFACT.name();
    }

    private static String fileAssetKindFor(MavenPath mavenPath, MavenPathParser mavenPathParser) {
        if (mavenPathParser.isRepositoryMetadata(mavenPath)) {
            return Attributes.AssetKind.REPOSITORY_METADATA.name();
        }
        if (mavenPathParser.isRepositoryIndex(mavenPath)) {
            return Attributes.AssetKind.REPOSITORY_INDEX.name();
        }
        return Attributes.AssetKind.OTHER.name();
    }

    private static void fillInBaseVersionColumn(Maven2ComponentStore componentStore, Component component, int repositoryId, String baseVersion) {
        Maven2ComponentData componentData = new Maven2ComponentData();
        componentData.setNamespace(component.namespace());
        componentData.setName(component.name());
        componentData.setVersion(component.version());
        componentData.setRepositoryId(repositoryId);
        componentData.setBaseVersion(baseVersion);
        componentStore.updateBaseVersion(componentData);
    }
}

