/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.content.maven.internal.recipe;

import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.content.maven.MavenArchetypeCatalogFacet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Response;

@Named
@Singleton
public class MavenArchetypeCatalogHandler
extends ComponentSupport
implements Handler {
    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        String method;
        switch (method = context.getRequest().getAction()) {
            case "GET": 
            case "HEAD": {
                return this.fetchOrGenerateArchetypeCatalog(context);
            }
        }
        return HttpResponses.methodNotAllowed((String)context.getRequest().getAction(), (String[])new String[]{"GET", "HEAD"});
    }

    private Response fetchOrGenerateArchetypeCatalog(Context context) throws Exception {
        Response response = context.proceed();
        if (!response.getStatus().isSuccessful()) {
            return this.generateArchetypeCatalog(context);
        }
        return response;
    }

    private Response generateArchetypeCatalog(Context context) throws Exception {
        Repository repository = context.getRepository();
        MavenArchetypeCatalogFacet archetypeCatalogFacet = (MavenArchetypeCatalogFacet)repository.facet(MavenArchetypeCatalogFacet.class);
        archetypeCatalogFacet.rebuildArchetypeCatalog();
        return context.proceed();
    }
}

