/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.content.maven.internal.index;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;
import org.apache.maven.index.reader.Record;
import org.sonatype.nexus.content.maven.internal.index.MavenContentIndexFacetSupport;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.ConfigurationFacet;
import org.sonatype.nexus.repository.maven.internal.MavenIndexPublisher;
import org.sonatype.nexus.repository.maven.internal.filter.DuplicateDetectionStrategy;
import org.sonatype.nexus.repository.maven.internal.filter.DuplicateDetectionStrategyProvider;
import org.sonatype.nexus.repository.types.ProxyType;

@Named
public class MavenContentProxyIndexFacet
extends MavenContentIndexFacetSupport {
    static final String CONFIG_KEY = "maven-indexer";
    private Config config;
    private final DuplicateDetectionStrategyProvider duplicateDetectionStrategyProvider;

    @Inject
    public MavenContentProxyIndexFacet(MavenIndexPublisher mavenIndexPublisher, DuplicateDetectionStrategyProvider duplicateDetectionStrategyProvider) {
        super(mavenIndexPublisher);
        this.duplicateDetectionStrategyProvider = (DuplicateDetectionStrategyProvider)((Object)Preconditions.checkNotNull((Object)((Object)duplicateDetectionStrategyProvider)));
    }

    protected void doValidate(Configuration configuration) {
        ((ConfigurationFacet)this.facet(ConfigurationFacet.class)).validateSection(configuration, CONFIG_KEY, Config.class, new Class[]{Default.class, this.getRepository().getType().getValidationGroup()});
    }

    protected void doConfigure(Configuration configuration) {
        this.config = (Config)((ConfigurationFacet)this.facet(ConfigurationFacet.class)).readSection(configuration, CONFIG_KEY, Config.class);
        this.log.debug("Config: {}", (Object)this.config);
    }

    @Override
    public void publishIndex() throws IOException {
        this.log.debug("Fetching maven index properties from remote");
        Throwable throwable = null;
        Object var2_3 = null;
        try (Object strategy = this.duplicateDetectionStrategyProvider.get();){
            this.mavenIndexPublisher.publishProxyIndex(this.getRepository(), this.config.cacheFallback, (DuplicateDetectionStrategy<Record>)strategy);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @VisibleForTesting
    static class Config {
        @NotNull(groups={ProxyType.ValidationGroup.class})
        public Boolean cacheFallback = Boolean.FALSE;

        Config() {
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "{" + "cacheFallback=" + this.cacheFallback + '}';
        }
    }
}

