/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.content.maven.internal.index;

import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.index.reader.IndexWriter;
import org.apache.maven.index.reader.Record;
import org.apache.maven.index.reader.RecordCompactor;
import org.apache.maven.index.reader.WritableResourceHandler;
import org.joda.time.DateTime;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.content.maven.MavenContentFacet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentQuery;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.MavenPathParser;
import org.sonatype.nexus.repository.maven.internal.Attributes;
import org.sonatype.nexus.repository.maven.internal.MavenIndexPublisher;
import org.sonatype.nexus.repository.maven.internal.filter.DuplicateDetectionStrategy;
import org.sonatype.nexus.repository.view.Content;

@Named
@Singleton
public class MavenContentIndexPublisher
extends MavenIndexPublisher {
    private final int browseAssetsPageSize;

    @Inject
    public MavenContentIndexPublisher(@Named(value="${nexus.maven.index.publisher.browseAssetsPageSize:-1000}") @Named(value="${nexus.maven.index.publisher.browseAssetsPageSize:-1000}") int browseAssetsPageSize) {
        this.browseAssetsPageSize = browseAssetsPageSize;
    }

    @Override
    protected MavenPathParser getMavenPathParser(Repository repository) {
        return ((MavenContentFacet)repository.facet(MavenContentFacet.class)).getMavenPathParser();
    }

    @Override
    protected WritableResourceHandler getResourceHandler(Repository repository) {
        return new Maven2WritableResourceHandler(repository);
    }

    @Override
    protected boolean delete(Repository repository, String path) throws IOException {
        MavenContentFacet mavenContentFacet = (MavenContentFacet)repository.facet(MavenContentFacet.class);
        MavenPath mavenPath = this.getMavenPathParser(repository).parsePath(path);
        return mavenContentFacet.delete(mavenPath);
    }

    @Override
    protected Iterable<Iterable<Record>> getGroupRecords(List<Repository> repositories, Closer closer) throws IOException {
        ArrayList<Iterable<Record>> records = new ArrayList<Iterable<Record>>();
        for (Repository repository : repositories) {
            records.add(this.getRecords(repository, closer));
        }
        return records;
    }

    @Override
    public void publishHostedIndex(Repository repository, DuplicateDetectionStrategy<Record> duplicateDetectionStrategy) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Maven2WritableResourceHandler resourceHandler = new Maven2WritableResourceHandler(repository);){
            Throwable throwable2 = null;
            Object var7_10 = null;
            try (IndexWriter indexWriter = new IndexWriter((WritableResourceHandler)resourceHandler, repository.getName(), false);){
                indexWriter.writeChunk(this.records(repository, duplicateDetectionStrategy).iterator());
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private Iterable<Map<String, String>> records(Repository repository, DuplicateDetectionStrategy<Record> duplicateDetectionStrategy) {
        List<Record> hostedRecords = this.getHostedRecords(repository, duplicateDetectionStrategy);
        return StreamSupport.stream(MavenContentIndexPublisher.decorate(hostedRecords, repository.getName()).spliterator(), false).map(arg_0 -> ((RecordCompactor)RECORD_COMPACTOR).apply(arg_0)).collect(Collectors.toList());
    }

    private List<Record> getHostedRecords(Repository repository, DuplicateDetectionStrategy<Record> duplicateDetectionStrategy) {
        ArrayList<Record> records = new ArrayList<Record>();
        MavenContentFacet mavenContentFacet = (MavenContentFacet)repository.facet(MavenContentFacet.class);
        FluentQuery artifactQuery = mavenContentFacet.assets().byKind(Attributes.AssetKind.ARTIFACT.name());
        Continuation assets = artifactQuery.browse(this.browseAssetsPageSize, null);
        while (!assets.isEmpty()) {
            records.addAll(this.assetsToRecords((Continuation<FluentAsset>)assets, mavenContentFacet, duplicateDetectionStrategy));
            assets = artifactQuery.browse(this.browseAssetsPageSize, assets.nextContinuationToken());
        }
        return records;
    }

    private List<Record> assetsToRecords(Continuation<FluentAsset> assets, MavenContentFacet mavenContentFacet, DuplicateDetectionStrategy<Record> duplicateDetectionStrategy) {
        return assets.stream().filter(Asset::hasBlob).filter(asset -> asset.component().isPresent()).map(asset -> this.toRecord((FluentAsset)asset, mavenContentFacet)).filter((Predicate<Record>)((Object)duplicateDetectionStrategy)).collect(Collectors.toList());
    }

    private Record toRecord(FluentAsset asset, MavenContentFacet mavenContentFacet) {
        MavenPath mavenPath = mavenContentFacet.getMavenPathParser().parsePath(asset.path());
        Preconditions.checkArgument((mavenPath.getCoordinates() != null && !mavenPath.isSubordinate() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)asset.component().isPresent());
        Component component = (Component)asset.component().get();
        Record assetRecord = new Record(Record.Type.ARTIFACT_ADD, new HashMap());
        OffsetDateTime lastUpdated = ((AssetBlob)asset.blob().get()).blobCreated();
        assetRecord.put(Record.REC_MODIFIED, (Object)lastUpdated.toEpochSecond());
        assetRecord.put(Record.GROUP_ID, (Object)component.namespace());
        assetRecord.put(Record.ARTIFACT_ID, (Object)component.name());
        Optional.ofNullable(asset.attributes("maven2").get("classifier")).ifPresent(classifier -> {
            Object object = assetRecord.put(Record.CLASSIFIER, (Object)classifier.toString());
        });
        this.copyComponentAttributes(mavenPath, component.attributes("maven2"), assetRecord);
        assetRecord.put(Record.HAS_SOURCES, (Object)mavenContentFacet.exists(mavenPath.locate("jar", "sources")));
        assetRecord.put(Record.HAS_JAVADOC, (Object)mavenContentFacet.exists(mavenPath.locate("jar", "javadoc")));
        assetRecord.put(Record.HAS_SIGNATURE, (Object)mavenContentFacet.exists(mavenPath.signature(MavenPath.SignatureType.GPG)));
        assetRecord.put(Record.FILE_EXTENSION, (Object)MavenContentIndexPublisher.pathExtension(mavenPath.getFileName()));
        Optional.ofNullable(asset.download().getAttributes().get("last_modified")).ifPresent(contentLastModified -> {
            Object object = assetRecord.put(Record.FILE_MODIFIED, (Object)DateTime.parse((String)contentLastModified.toString()).getMillis());
        });
        this.copyBlobAttributes(asset, assetRecord);
        return assetRecord;
    }

    private void copyComponentAttributes(MavenPath mavenPath, NestedAttributesMap componentFormatAttributes, Record assetRecord) {
        Optional.ofNullable(componentFormatAttributes.get("baseVersion")).ifPresent(baseVersion -> {
            Object object = assetRecord.put(Record.VERSION, (Object)baseVersion.toString());
        });
        String packaging = Optional.ofNullable(componentFormatAttributes.get("packaging")).map(Object::toString).orElseGet(() -> MavenContentIndexPublisher.pathExtension(mavenPath.getFileName()));
        assetRecord.put(Record.PACKAGING, (Object)packaging);
        assetRecord.put(Record.NAME, (Object)Optional.ofNullable(componentFormatAttributes.get("pom_name")).map(Object::toString).orElse(""));
        assetRecord.put(Record.NAME, (Object)Optional.ofNullable(componentFormatAttributes.get("pom_description")).map(Object::toString).orElse(""));
    }

    private void copyBlobAttributes(FluentAsset asset, Record assetRecord) {
        asset.blob().ifPresent(assetBlob -> {
            assetRecord.put(Record.FILE_SIZE, (Object)assetBlob.blobSize());
            assetRecord.put(Record.SHA1, (Object)((String)assetBlob.checksums().get(HashAlgorithm.SHA1.name())));
        });
    }

    private static class Maven2WritableResource
    implements WritableResourceHandler.WritableResource {
        private final MavenPath mavenPath;
        private final MavenContentFacet mavenFacet;
        private final String contentType;
        private Path path;

        private Maven2WritableResource(MavenPath mavenPath, MavenContentFacet mavenFacet, String contentType) {
            this.mavenPath = mavenPath;
            this.mavenFacet = mavenFacet;
            this.contentType = contentType;
            this.path = null;
        }

        public InputStream read() throws IOException {
            Optional<Content> content = this.mavenFacet.get(this.mavenPath);
            if (content.isPresent()) {
                return content.get().openInputStream();
            }
            return null;
        }

        public OutputStream write() throws IOException {
            this.path = File.createTempFile(this.mavenPath.getFileName(), "tmp").toPath();
            return new BufferedOutputStream(Files.newOutputStream(this.path, new OpenOption[0]));
        }

        public void close() throws IOException {
            if (this.path != null) {
                this.mavenFacet.put(this.mavenPath, MavenContentIndexPublisher.createPayload(this.path, this.contentType));
                Files.delete(this.path);
                this.path = null;
            }
        }
    }

    static class Maven2WritableResourceHandler
    implements WritableResourceHandler {
        private final MavenContentFacet mavenFacet;

        Maven2WritableResourceHandler(Repository repository) {
            this.mavenFacet = (MavenContentFacet)repository.facet(MavenContentFacet.class);
        }

        public Maven2WritableResource locate(String name) {
            MavenPath mavenPath = this.mavenFacet.getMavenPathParser().parsePath("/.index/" + name);
            return new Maven2WritableResource(mavenPath, this.mavenFacet, MavenContentIndexPublisher.determineContentType(name));
        }

        public void close() {
        }
    }
}

