/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.content.maven.internal.browse;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.browse.node.BrowsePath;
import org.sonatype.nexus.repository.browse.node.BrowsePathBuilder;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.browse.ComponentPathBrowseNodeGenerator;

@Singleton
@Named(value="maven2")
public class Maven2BrowseNodeGenerator
extends ComponentPathBrowseNodeGenerator {
    static final String BASE_VERSION = "baseVersion";

    public List<BrowsePath> computeAssetPaths(Asset asset) {
        Preconditions.checkNotNull((Object)asset);
        return asset.component().map(component -> {
            List<BrowsePath> assetPaths = this.computeComponentPaths(asset);
            BrowsePathBuilder.appendPath(assetPaths, (String)this.lastSegment(asset.path()), (String)asset.path());
            return assetPaths;
        }).orElseGet(() -> super.computeAssetPaths(asset));
    }

    public List<BrowsePath> computeComponentPaths(Asset asset) {
        Preconditions.checkNotNull((Object)asset);
        Component component = (Component)asset.component().get();
        List<String> componentPath = this.pathToArtifactFolder(component);
        String version = component.version();
        if (!Strings2.isBlank((String)version) && !version.equals(componentPath.get(componentPath.size() - 1))) {
            componentPath.add(version);
        }
        return BrowsePathBuilder.fromPaths(componentPath, (boolean)true);
    }

    private List<String> pathToArtifactFolder(Component component) {
        ArrayList<String> paths = new ArrayList<String>();
        String groupId = component.namespace();
        String artifactId = component.name();
        String version = component.version();
        if (!Strings2.isBlank((String)groupId)) {
            paths.addAll(Splitter.on((char)'.').omitEmptyStrings().splitToList((CharSequence)groupId));
        }
        paths.add(artifactId);
        if (!Strings2.isBlank((String)version)) {
            paths.add(this.baseVersion(component, version));
        }
        return paths;
    }

    private String baseVersion(Component component, String version) {
        return (String)component.attributes().child("maven2").get(BASE_VERSION, String.class, (Object)version);
    }
}

