/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.content.maven.internal;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.elasticsearch.search.lookup.SourceLookup;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.security.AssetVariableResolverSupport;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.MavenPathParser;
import org.sonatype.nexus.repository.maven.internal.utils.MavenVariableResolverAdapterUtil;
import org.sonatype.nexus.repository.search.AssetSearchResult;
import org.sonatype.nexus.repository.search.ComponentSearchResult;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.selector.VariableSourceBuilder;

@Named(value="maven2")
public class MavenVariableResolverAdapter
extends AssetVariableResolverSupport {
    private final MavenPathParser mavenPathParser;

    @Inject
    public MavenVariableResolverAdapter(@Named(value="maven2") @Named(value="maven2") MavenPathParser mavenPathParser) {
        this.mavenPathParser = (MavenPathParser)Preconditions.checkNotNull((Object)mavenPathParser);
    }

    protected void addFromRequest(VariableSourceBuilder builder, Request request) {
        this.addMavenCoordinates(builder, request.getPath());
    }

    protected void addFromSourceLookup(VariableSourceBuilder builder, SourceLookup sourceLookup, Map<String, Object> asset) {
        this.addMavenCoordinates(builder, (String)asset.get("name"));
    }

    protected void addFromSearchResults(VariableSourceBuilder builder, ComponentSearchResult component, AssetSearchResult asset) {
        this.addMavenCoordinates(builder, asset.getPath());
    }

    protected void addFromAsset(VariableSourceBuilder builder, FluentAsset asset) {
        this.addMavenCoordinates(builder, asset.path());
    }

    private void addMavenCoordinates(VariableSourceBuilder builder, String path) {
        Preconditions.checkNotNull((Object)builder);
        Preconditions.checkNotNull((Object)path);
        MavenPath.Coordinates coords = this.mavenPathParser.parsePath(path).getCoordinates();
        if (coords != null) {
            this.addCoordinates(builder, MavenVariableResolverAdapterUtil.createCoordinateMap(coords));
        }
    }
}

